/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.ldap.service;

import id.onyx.obdp.server.ldap.domain.OBDPLdapConfiguration;
import id.onyx.obdp.server.ldap.service.AmbariLdapException;
import id.onyx.obdp.server.ldap.service.LdapAttributeDetectionService;
import id.onyx.obdp.server.ldap.service.LdapConfigurationService;
import id.onyx.obdp.server.ldap.service.LdapFacade;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AmbariLdapFacade
implements LdapFacade {
    private static final Logger LOGGER = LoggerFactory.getLogger(AmbariLdapFacade.class);
    @Inject
    private LdapConfigurationService ldapConfigurationService;
    @Inject
    private LdapAttributeDetectionService ldapAttributeDetectionService;

    @Inject
    public AmbariLdapFacade() {
    }

    @Override
    public void checkConnection(OBDPLdapConfiguration ambariLdapConfiguration) throws AmbariLdapException {
        try {
            this.ldapConfigurationService.checkConnection(ambariLdapConfiguration);
            LOGGER.info("Validating LDAP connection related configuration: SUCCESS");
        }
        catch (Exception e) {
            LOGGER.error("Validating LDAP connection configuration failed", (Throwable)e);
            throw new AmbariLdapException(e);
        }
    }

    @Override
    public OBDPLdapConfiguration detectAttributes(OBDPLdapConfiguration ambariLdapConfiguration) throws AmbariLdapException {
        LOGGER.info("Detecting LDAP configuration attributes ...");
        try {
            LOGGER.info("Detecting user attributes ....");
            ambariLdapConfiguration = this.ldapAttributeDetectionService.detectLdapUserAttributes(ambariLdapConfiguration);
            LOGGER.info("Detecting group attributes ....");
            ambariLdapConfiguration = this.ldapAttributeDetectionService.detectLdapGroupAttributes(ambariLdapConfiguration);
            LOGGER.info("Attribute detection finished.");
            return ambariLdapConfiguration;
        }
        catch (Exception e) {
            LOGGER.error("Error during LDAP attribute detection", (Throwable)e);
            throw new AmbariLdapException(e);
        }
    }

    @Override
    public Set<String> checkLdapAttributes(Map<String, Object> parameters, OBDPLdapConfiguration ldapConfiguration) throws AmbariLdapException {
        String userName = this.getTestUserNameFromParameters(parameters);
        String testUserPass = this.getTestUserPasswordFromParameters(parameters);
        if (null == userName) {
            throw new IllegalArgumentException("No test user available for testing LDAP attributes");
        }
        LOGGER.info("Testing LDAP user attributes with test user: {}", (Object)userName);
        String userDn = this.ldapConfigurationService.checkUserAttributes(userName, testUserPass, ldapConfiguration);
        LOGGER.info("Testing LDAP group attributes with test user dn: {}", (Object)userDn);
        return this.ldapConfigurationService.checkGroupAttributes(userDn, ldapConfiguration);
    }

    private String getTestUserNameFromParameters(Map<String, Object> parameters) {
        return (String)this.parameterValue(parameters, Parameters.TEST_USER_NAME);
    }

    private String getTestUserPasswordFromParameters(Map<String, Object> parameters) {
        return (String)this.parameterValue(parameters, Parameters.TEST_USER_PASSWORD);
    }

    private Object parameterValue(Map<String, Object> parameters, Parameters parameter) {
        Object value = null;
        if (parameters.containsKey(parameter.getParameterKey())) {
            value = parameters.get(parameter.getParameterKey());
        } else {
            LOGGER.warn("Parameter [{}] is missing from parameters", (Object)parameter.getParameterKey());
        }
        return value;
    }

    public static enum Parameters {
        TEST_USER_NAME("ambari.ldap.test.user.name"),
        TEST_USER_PASSWORD("ambari.ldap.test.user.password");

        private String parameterKey;

        private Parameters(String parameterKey) {
            this.parameterKey = parameterKey;
        }

        public String getParameterKey() {
            return this.parameterKey;
        }
    }
}

