/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.ldap.domain;

import id.onyx.obdp.server.configuration.LdapUsernameCollisionHandlingBehavior;
import id.onyx.obdp.server.configuration.OBDPServerConfiguration;
import id.onyx.obdp.server.configuration.OBDPServerConfigurationCategory;
import id.onyx.obdp.server.configuration.OBDPServerConfigurationKey;
import id.onyx.obdp.server.security.authorization.LdapServerProperties;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class OBDPLdapConfiguration
extends OBDPServerConfiguration {
    public OBDPLdapConfiguration() {
        this(null);
    }

    public OBDPLdapConfiguration(Map<String, String> configurationMap) {
        super(configurationMap);
    }

    @Override
    protected OBDPServerConfigurationCategory getCategory() {
        return OBDPServerConfigurationCategory.LDAP_CONFIGURATION;
    }

    public boolean isAmbariManagesLdapConfiguration() {
        return Boolean.valueOf(this.configValue(OBDPServerConfigurationKey.AMBARI_MANAGES_LDAP_CONFIGURATION));
    }

    public String getLdapEnabledServices() {
        return this.configValue(OBDPServerConfigurationKey.LDAP_ENABLED_SERVICES);
    }

    public boolean ldapEnabled() {
        return Boolean.valueOf(this.configValue(OBDPServerConfigurationKey.LDAP_ENABLED));
    }

    public String serverHost() {
        return this.configValue(OBDPServerConfigurationKey.SERVER_HOST);
    }

    public int serverPort() {
        return Integer.parseInt(this.configValue(OBDPServerConfigurationKey.SERVER_PORT));
    }

    public String serverUrl() {
        return this.serverHost() + ":" + this.serverPort();
    }

    public String secondaryServerHost() {
        return this.configValue(OBDPServerConfigurationKey.SECONDARY_SERVER_HOST);
    }

    public int secondaryServerPort() {
        String secondaryServerPort = this.configValue(OBDPServerConfigurationKey.SECONDARY_SERVER_PORT);
        return secondaryServerPort == null ? 0 : Integer.parseInt(secondaryServerPort);
    }

    public String secondaryServerUrl() {
        return this.secondaryServerHost() + ":" + this.secondaryServerPort();
    }

    public boolean useSSL() {
        return Boolean.valueOf(this.configValue(OBDPServerConfigurationKey.USE_SSL));
    }

    public String trustStore() {
        return this.configValue(OBDPServerConfigurationKey.TRUST_STORE);
    }

    public String trustStoreType() {
        return this.configValue(OBDPServerConfigurationKey.TRUST_STORE_TYPE);
    }

    public String trustStorePath() {
        return this.configValue(OBDPServerConfigurationKey.TRUST_STORE_PATH);
    }

    public String trustStorePassword() {
        return this.configValue(OBDPServerConfigurationKey.TRUST_STORE_PASSWORD);
    }

    public boolean anonymousBind() {
        return Boolean.valueOf(this.configValue(OBDPServerConfigurationKey.ANONYMOUS_BIND));
    }

    public String bindDn() {
        return this.configValue(OBDPServerConfigurationKey.BIND_DN);
    }

    public String bindPassword() {
        return this.configValue(OBDPServerConfigurationKey.BIND_PASSWORD);
    }

    public String attributeDetection() {
        return this.configValue(OBDPServerConfigurationKey.ATTR_DETECTION);
    }

    public String dnAttribute() {
        return this.configValue(OBDPServerConfigurationKey.DN_ATTRIBUTE);
    }

    public String userObjectClass() {
        return this.configValue(OBDPServerConfigurationKey.USER_OBJECT_CLASS);
    }

    public String userNameAttribute() {
        return this.configValue(OBDPServerConfigurationKey.USER_NAME_ATTRIBUTE);
    }

    public String userSearchBase() {
        return this.configValue(OBDPServerConfigurationKey.USER_SEARCH_BASE);
    }

    public String groupObjectClass() {
        return this.configValue(OBDPServerConfigurationKey.GROUP_OBJECT_CLASS);
    }

    public String groupNameAttribute() {
        return this.configValue(OBDPServerConfigurationKey.GROUP_NAME_ATTRIBUTE);
    }

    public String groupMemberAttribute() {
        return this.configValue(OBDPServerConfigurationKey.GROUP_MEMBER_ATTRIBUTE);
    }

    public String groupSearchBase() {
        return this.configValue(OBDPServerConfigurationKey.GROUP_SEARCH_BASE);
    }

    public String groupMappingRules() {
        return this.configValue(OBDPServerConfigurationKey.GROUP_MAPPING_RULES);
    }

    public String userSearchFilter() {
        return this.configValue(OBDPServerConfigurationKey.USER_SEARCH_FILTER);
    }

    public String userMemberReplacePattern() {
        return this.configValue(OBDPServerConfigurationKey.USER_MEMBER_REPLACE_PATTERN);
    }

    public String userMemberFilter() {
        return this.configValue(OBDPServerConfigurationKey.USER_MEMBER_FILTER);
    }

    public String groupSearchFilter() {
        return this.configValue(OBDPServerConfigurationKey.GROUP_SEARCH_FILTER);
    }

    public String groupMemberReplacePattern() {
        return this.configValue(OBDPServerConfigurationKey.GROUP_MEMBER_REPLACE_PATTERN);
    }

    public String groupMemberFilter() {
        return this.configValue(OBDPServerConfigurationKey.GROUP_MEMBER_FILTER);
    }

    public boolean forceLowerCaseUserNames() {
        return Boolean.valueOf(this.configValue(OBDPServerConfigurationKey.FORCE_LOWERCASE_USERNAMES));
    }

    public boolean paginationEnabled() {
        return Boolean.valueOf(this.configValue(OBDPServerConfigurationKey.PAGINATION_ENABLED));
    }

    public String referralHandling() {
        return this.configValue(OBDPServerConfigurationKey.REFERRAL_HANDLING);
    }

    public boolean disableEndpointIdentification() {
        return Boolean.valueOf(this.configValue(OBDPServerConfigurationKey.DISABLE_ENDPOINT_IDENTIFICATION));
    }

    @Override
    public Map<String, String> toMap() {
        return new HashMap<String, String>(this.configurationMap);
    }

    public String toString() {
        return this.configurationMap.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBDPLdapConfiguration that = (OBDPLdapConfiguration)o;
        return new EqualsBuilder().append((Object)this.configurationMap, (Object)that.configurationMap).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.configurationMap).toHashCode();
    }

    public boolean isLdapAlternateUserSearchEnabled() {
        return Boolean.valueOf(this.configValue(OBDPServerConfigurationKey.ALTERNATE_USER_SEARCH_ENABLED));
    }

    public LdapServerProperties getLdapServerProperties() {
        LdapServerProperties ldapServerProperties = new LdapServerProperties();
        ldapServerProperties.setPrimaryUrl(this.serverUrl());
        if (StringUtils.isNotBlank((String)this.secondaryServerHost())) {
            ldapServerProperties.setSecondaryUrl(this.secondaryServerUrl());
        }
        ldapServerProperties.setUseSsl(Boolean.parseBoolean(this.configValue(OBDPServerConfigurationKey.USE_SSL)));
        ldapServerProperties.setAnonymousBind(Boolean.parseBoolean(this.configValue(OBDPServerConfigurationKey.ANONYMOUS_BIND)));
        ldapServerProperties.setManagerDn(this.configValue(OBDPServerConfigurationKey.BIND_DN));
        ldapServerProperties.setManagerPassword(this.configValue(OBDPServerConfigurationKey.BIND_PASSWORD));
        ldapServerProperties.setBaseDN(this.configValue(OBDPServerConfigurationKey.USER_SEARCH_BASE));
        ldapServerProperties.setUsernameAttribute(this.configValue(OBDPServerConfigurationKey.USER_NAME_ATTRIBUTE));
        ldapServerProperties.setForceUsernameToLowercase(Boolean.parseBoolean(this.configValue(OBDPServerConfigurationKey.FORCE_LOWERCASE_USERNAMES)));
        ldapServerProperties.setUserBase(this.configValue(OBDPServerConfigurationKey.USER_BASE));
        ldapServerProperties.setUserObjectClass(this.configValue(OBDPServerConfigurationKey.USER_OBJECT_CLASS));
        ldapServerProperties.setDnAttribute(this.configValue(OBDPServerConfigurationKey.DN_ATTRIBUTE));
        ldapServerProperties.setGroupBase(this.configValue(OBDPServerConfigurationKey.GROUP_BASE));
        ldapServerProperties.setGroupObjectClass(this.configValue(OBDPServerConfigurationKey.GROUP_OBJECT_CLASS));
        ldapServerProperties.setGroupMembershipAttr(this.configValue(OBDPServerConfigurationKey.GROUP_MEMBER_ATTRIBUTE));
        ldapServerProperties.setGroupNamingAttr(this.configValue(OBDPServerConfigurationKey.GROUP_NAME_ATTRIBUTE));
        ldapServerProperties.setAdminGroupMappingRules(this.configValue(OBDPServerConfigurationKey.GROUP_MAPPING_RULES));
        ldapServerProperties.setAdminGroupMappingMemberAttr("");
        ldapServerProperties.setUserSearchFilter(this.configValue(OBDPServerConfigurationKey.USER_SEARCH_FILTER));
        ldapServerProperties.setAlternateUserSearchFilter(this.configValue(OBDPServerConfigurationKey.ALTERNATE_USER_SEARCH_FILTER));
        ldapServerProperties.setGroupSearchFilter(this.configValue(OBDPServerConfigurationKey.GROUP_SEARCH_FILTER));
        ldapServerProperties.setReferralMethod(this.configValue(OBDPServerConfigurationKey.REFERRAL_HANDLING));
        ldapServerProperties.setSyncUserMemberReplacePattern(this.configValue(OBDPServerConfigurationKey.USER_MEMBER_REPLACE_PATTERN));
        ldapServerProperties.setSyncGroupMemberReplacePattern(this.configValue(OBDPServerConfigurationKey.GROUP_MEMBER_REPLACE_PATTERN));
        ldapServerProperties.setSyncUserMemberFilter(this.configValue(OBDPServerConfigurationKey.USER_MEMBER_FILTER));
        ldapServerProperties.setSyncGroupMemberFilter(this.configValue(OBDPServerConfigurationKey.GROUP_MEMBER_FILTER));
        ldapServerProperties.setPaginationEnabled(Boolean.parseBoolean(this.configValue(OBDPServerConfigurationKey.PAGINATION_ENABLED)));
        ldapServerProperties.setDisableEndpointIdentification(this.disableEndpointIdentification());
        if (this.hasAnyValueWithKey(OBDPServerConfigurationKey.GROUP_BASE, OBDPServerConfigurationKey.GROUP_OBJECT_CLASS, OBDPServerConfigurationKey.GROUP_MEMBER_ATTRIBUTE, OBDPServerConfigurationKey.GROUP_NAME_ATTRIBUTE, OBDPServerConfigurationKey.GROUP_MAPPING_RULES, OBDPServerConfigurationKey.GROUP_SEARCH_FILTER)) {
            ldapServerProperties.setGroupMappingEnabled(true);
        }
        return ldapServerProperties;
    }

    private boolean hasAnyValueWithKey(OBDPServerConfigurationKey ... ambariServerConfigurationKey) {
        for (OBDPServerConfigurationKey key : ambariServerConfigurationKey) {
            if (!this.configurationMap.containsKey(key.key())) continue;
            return true;
        }
        return false;
    }

    public LdapUsernameCollisionHandlingBehavior syncCollisionHandlingBehavior() {
        if ("skip".equalsIgnoreCase(this.configValue(OBDPServerConfigurationKey.COLLISION_BEHAVIOR))) {
            return LdapUsernameCollisionHandlingBehavior.SKIP;
        }
        return LdapUsernameCollisionHandlingBehavior.CONVERT;
    }

    private String configValue(OBDPServerConfigurationKey ambariManagesLdapConfiguration) {
        return this.getValue(ambariManagesLdapConfiguration, this.configurationMap);
    }
}

