/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.ldap;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Names;
import id.onyx.obdp.server.ldap.domain.OBDPLdapConfiguration;
import id.onyx.obdp.server.ldap.service.AmbariLdapFacade;
import id.onyx.obdp.server.ldap.service.AttributeDetector;
import id.onyx.obdp.server.ldap.service.LdapAttributeDetectionService;
import id.onyx.obdp.server.ldap.service.LdapConfigurationService;
import id.onyx.obdp.server.ldap.service.LdapConnectionConfigService;
import id.onyx.obdp.server.ldap.service.LdapFacade;
import id.onyx.obdp.server.ldap.service.OBDPLdapConfigurationProvider;
import id.onyx.obdp.server.ldap.service.ads.DefaultLdapAttributeDetectionService;
import id.onyx.obdp.server.ldap.service.ads.DefaultLdapConfigurationService;
import id.onyx.obdp.server.ldap.service.ads.DefaultLdapConnectionConfigService;
import id.onyx.obdp.server.ldap.service.ads.detectors.AttributeDetectorFactory;
import id.onyx.obdp.server.ldap.service.ads.detectors.GroupMemberAttrDetector;
import id.onyx.obdp.server.ldap.service.ads.detectors.GroupNameAttrDetector;
import id.onyx.obdp.server.ldap.service.ads.detectors.GroupObjectClassDetector;
import id.onyx.obdp.server.ldap.service.ads.detectors.UserGroupMemberAttrDetector;
import id.onyx.obdp.server.ldap.service.ads.detectors.UserNameAttrDetector;
import id.onyx.obdp.server.ldap.service.ads.detectors.UserObjectClassDetector;
import java.lang.annotation.Annotation;

public class LdapModule
extends AbstractModule {
    public static final String USER_ATTRIBUTES_DETECTORS = "UserAttributesDetectors";
    public static final String GROUP_ATTRIBUTES_DETECTORS = "GroupAttributesDetectors";

    protected void configure() {
        this.bind(LdapFacade.class).to(AmbariLdapFacade.class);
        this.bind(LdapConfigurationService.class).to(DefaultLdapConfigurationService.class);
        this.bind(LdapAttributeDetectionService.class).to(DefaultLdapAttributeDetectionService.class);
        this.bind(LdapConnectionConfigService.class).to(DefaultLdapConnectionConfigService.class);
        this.bind(OBDPLdapConfiguration.class).toProvider(OBDPLdapConfigurationProvider.class);
        this.bind(AttributeDetectorFactory.class);
        Multibinder userAttributeDetectorBinder = Multibinder.newSetBinder((Binder)this.binder(), AttributeDetector.class, (Annotation)Names.named((String)USER_ATTRIBUTES_DETECTORS));
        userAttributeDetectorBinder.addBinding().to(UserObjectClassDetector.class);
        userAttributeDetectorBinder.addBinding().to(UserNameAttrDetector.class);
        userAttributeDetectorBinder.addBinding().to(UserGroupMemberAttrDetector.class);
        Multibinder groupAttributeDetectorBinder = Multibinder.newSetBinder((Binder)this.binder(), AttributeDetector.class, (Annotation)Names.named((String)GROUP_ATTRIBUTES_DETECTORS));
        groupAttributeDetectorBinder.addBinding().to(GroupObjectClassDetector.class);
        groupAttributeDetectorBinder.addBinding().to(GroupNameAttrDetector.class);
        groupAttributeDetectorBinder.addBinding().to(GroupMemberAttrDetector.class);
    }
}

