/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.hooks.users;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.eventbus.Subscribe;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.Role;
import id.onyx.obdp.server.RoleCommand;
import id.onyx.obdp.server.actionmanager.ActionManager;
import id.onyx.obdp.server.actionmanager.RequestFactory;
import id.onyx.obdp.server.actionmanager.Stage;
import id.onyx.obdp.server.actionmanager.StageFactory;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.controller.internal.RequestStageContainer;
import id.onyx.obdp.server.events.publishers.OBDPEventPublisher;
import id.onyx.obdp.server.hooks.AmbariEventFactory;
import id.onyx.obdp.server.hooks.HookContext;
import id.onyx.obdp.server.hooks.HookService;
import id.onyx.obdp.server.hooks.users.PostUserCreationHookContext;
import id.onyx.obdp.server.hooks.users.UserCreatedEvent;
import id.onyx.obdp.server.hooks.users.UserHookParams;
import id.onyx.obdp.server.serveraction.users.PostUserCreationHookServerAction;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.svccomphost.ServiceComponentHostServerActionEvent;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class UserHookService
implements HookService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserHookService.class);
    private static final String POST_USER_CREATION_REQUEST_CONTEXT = "Post user creation hook for [ %s ] users";
    private static final String INPUT_FILE_PREFIX = "user_hook_input_%s.csv";
    private static final String HADOOP_ENV = "hadoop-env";
    private static final String HDFS_USER_KEYTAB = "hdfs_user_keytab";
    private static final String HDFS_PRINCIPAL_NAME = "hdfs_principal_name";
    @Inject
    private AmbariEventFactory eventFactory;
    @Inject
    private OBDPEventPublisher ambariEventPublisher;
    @Inject
    private ActionManager actionManager;
    @Inject
    private RequestFactory requestFactory;
    @Inject
    private StageFactory stageFactory;
    @Inject
    private Configuration configuration;
    @Inject
    private Clusters clusters;
    @Inject
    private ObjectMapper objectMapper;

    @Inject
    private void register() {
        this.ambariEventPublisher.register(this);
    }

    @Override
    public boolean execute(HookContext hookContext) {
        LOGGER.info("Executing user hook for {}. ", (Object)hookContext);
        PostUserCreationHookContext hookCtx = this.validateHookInput(hookContext);
        if (!this.checkUserHookPrerequisites()) {
            LOGGER.warn("Prerequisites for user hook are not satisfied. Hook not triggered");
            return false;
        }
        if (hookCtx.getUserGroups().isEmpty()) {
            LOGGER.info("No users found for executing user hook for");
            return false;
        }
        UserCreatedEvent userCreatedEvent = (UserCreatedEvent)this.eventFactory.newUserCreatedEvent(hookCtx);
        LOGGER.info("Triggering user hook for user: {}", (Object)hookContext);
        this.ambariEventPublisher.publish(userCreatedEvent);
        return true;
    }

    @Subscribe
    public void onUserCreatedEvent(UserCreatedEvent event) throws OBDPException {
        LOGGER.info("Preparing hook execution for event: {}", (Object)event);
        try {
            RequestStageContainer requestStageContainer = new RequestStageContainer(this.actionManager.getNextRequestId(), null, this.requestFactory, this.actionManager);
            ClusterData clsData = this.getClusterData();
            PostUserCreationHookContext ctx = (PostUserCreationHookContext)event.getContext();
            String stageContextText = String.format(POST_USER_CREATION_REQUEST_CONTEXT, ctx.getUserGroups().size());
            Stage stage = this.stageFactory.createNew(requestStageContainer.getId(), this.configuration.getServerTempDir() + File.pathSeparatorChar + requestStageContainer.getId(), clsData.getClusterName(), clsData.getClusterId(), stageContextText, "{}", "{}");
            stage.setStageId(requestStageContainer.getLastStageId());
            ServiceComponentHostServerActionEvent serverActionEvent = new ServiceComponentHostServerActionEvent("obdp-server-host", System.currentTimeMillis());
            Map<String, String> commandParams = this.prepareCommandParams(ctx, clsData);
            stage.addServerActionCommand(PostUserCreationHookServerAction.class.getName(), "ambari", Role.AMBARI_SERVER_ACTION, RoleCommand.EXECUTE, clsData.getClusterName(), serverActionEvent, commandParams, stageContextText, null, null, false, false);
            requestStageContainer.addStages(Collections.singletonList(stage));
            requestStageContainer.persist();
        }
        catch (IOException e) {
            LOGGER.error("Failed to assemble stage for server action. Event: {}", (Object)event);
            throw new OBDPException("Failed to assemble stage for server action", (Throwable)e);
        }
    }

    private Map<String, String> prepareCommandParams(PostUserCreationHookContext context, ClusterData clusterData) throws IOException {
        HashMap<String, String> commandParams = new HashMap<String, String>();
        commandParams.put(UserHookParams.SCRIPT.param(), this.configuration.getProperty(Configuration.POST_USER_CREATION_HOOK));
        commandParams.put(UserHookParams.CLUSTER_ID.param(), String.valueOf(clusterData.getClusterId()));
        commandParams.put(UserHookParams.CLUSTER_NAME.param(), clusterData.getClusterName());
        commandParams.put(UserHookParams.CLUSTER_SECURITY_TYPE.param(), clusterData.getSecurityType());
        commandParams.put(UserHookParams.CMD_HDFS_KEYTAB.param(), clusterData.getKeytab());
        commandParams.put(UserHookParams.CMD_HDFS_PRINCIPAL.param(), clusterData.getPrincipal());
        commandParams.put(UserHookParams.CMD_HDFS_USER.param(), clusterData.getHdfsUser());
        commandParams.put(UserHookParams.CMD_INPUT_FILE.param(), this.generateInputFileName());
        commandParams.put(UserHookParams.PAYLOAD.param(), this.objectMapper.writeValueAsString(context.getUserGroups()));
        return commandParams;
    }

    private String generateInputFileName() {
        String inputFileName = String.format(INPUT_FILE_PREFIX, Calendar.getInstance().getTimeInMillis());
        LOGGER.debug("Command input file name: {}", (Object)inputFileName);
        return this.configuration.getServerTempDir() + File.separator + inputFileName;
    }

    private boolean checkUserHookPrerequisites() {
        if (!this.configuration.isUserHookEnabled()) {
            LOGGER.warn("Post user creation hook disabled.");
            return false;
        }
        if (this.clusters.getClusters().isEmpty()) {
            LOGGER.warn("There's no cluster found. Post user creation hook won't be executed.");
            return false;
        }
        return true;
    }

    private PostUserCreationHookContext validateHookInput(HookContext hookContext) {
        return (PostUserCreationHookContext)hookContext;
    }

    private ClusterData getClusterData() {
        String keyTab = "NA";
        String principal = "NA";
        Map.Entry<String, Cluster> clustersMapEntry = this.clusters.getClusters().entrySet().iterator().next();
        Cluster cluster = clustersMapEntry.getValue();
        switch (cluster.getSecurityType()) {
            case KERBEROS: {
                Map<String, String> hadoopEnv = cluster.getDesiredConfigByType(HADOOP_ENV).getProperties();
                keyTab = hadoopEnv.get(HDFS_USER_KEYTAB);
                principal = hadoopEnv.get(HDFS_PRINCIPAL_NAME);
                break;
            }
            default: {
                LOGGER.debug("The cluster security is not set. Security type: {}", (Object)cluster.getSecurityType());
            }
        }
        return new ClusterData(cluster.getClusterName(), cluster.getClusterId(), cluster.getSecurityType().name(), principal, keyTab, this.getHdfsUser(cluster));
    }

    private String getHdfsUser(Cluster cluster) {
        String hdfsUser = cluster.getDesiredConfigByType(HADOOP_ENV).getProperties().get("hdfs_user");
        return hdfsUser;
    }

    private static final class ClusterData {
        private String clusterName;
        private Long clusterId;
        private String securityType;
        private String principal;
        private String keytab;
        private String hdfsUser;

        public ClusterData(String clusterName, Long clusterId, String securityType, String principal, String keytab, String hdfsUser) {
            this.clusterName = clusterName;
            this.clusterId = clusterId;
            this.securityType = securityType;
            this.principal = principal;
            this.keytab = keytab;
            this.hdfsUser = hdfsUser;
        }

        public String getClusterName() {
            return this.clusterName;
        }

        public Long getClusterId() {
            return this.clusterId;
        }

        public String getSecurityType() {
            return this.securityType;
        }

        public String getPrincipal() {
            return this.principal;
        }

        public String getKeytab() {
            return this.keytab;
        }

        public String getHdfsUser() {
            return this.hdfsUser;
        }
    }
}

