/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.events.publishers;

import com.google.common.eventbus.EventBus;
import com.google.inject.Inject;
import id.onyx.obdp.server.EagerSingleton;
import id.onyx.obdp.server.controller.utilities.ServiceCalculatedStateFactory;
import id.onyx.obdp.server.controller.utilities.state.ServiceCalculatedState;
import id.onyx.obdp.server.events.STOMPEvent;
import id.onyx.obdp.server.events.ServiceUpdateEvent;
import id.onyx.obdp.server.events.publishers.BufferedUpdateEventPublisher;
import id.onyx.obdp.server.events.publishers.STOMPUpdatePublisher;
import id.onyx.obdp.server.state.State;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@EagerSingleton
public class ServiceUpdateEventPublisher
extends BufferedUpdateEventPublisher<ServiceUpdateEvent> {
    private Map<String, Map<String, State>> states = new HashMap<String, Map<String, State>>();

    @Inject
    public ServiceUpdateEventPublisher(STOMPUpdatePublisher stompUpdatePublisher) {
        super(stompUpdatePublisher);
    }

    @Override
    public STOMPEvent.Type getType() {
        return STOMPEvent.Type.SERVICE;
    }

    @Override
    public void mergeBufferAndPost(List<ServiceUpdateEvent> events, EventBus eventBus) {
        ArrayList<ServiceUpdateEvent> filtered = new ArrayList<ServiceUpdateEvent>();
        for (ServiceUpdateEvent event : events) {
            int pos = filtered.indexOf(event);
            if (pos != -1) {
                if (event.isStateChanged()) {
                    ((ServiceUpdateEvent)filtered.get(pos)).setStateChanged(true);
                }
                if (event.getMaintenanceState() == null) continue;
                ((ServiceUpdateEvent)filtered.get(pos)).setMaintenanceState(event.getMaintenanceState());
                continue;
            }
            filtered.add(event);
        }
        for (ServiceUpdateEvent serviceUpdateEvent : filtered) {
            if (serviceUpdateEvent.isStateChanged()) {
                ServiceCalculatedState serviceCalculatedState = ServiceCalculatedStateFactory.getServiceStateProvider(serviceUpdateEvent.getServiceName());
                State serviceState = serviceCalculatedState.getState(serviceUpdateEvent.getClusterName(), serviceUpdateEvent.getServiceName());
                String serviceName = serviceUpdateEvent.getServiceName();
                String clusterName = serviceUpdateEvent.getClusterName();
                if (this.states.containsKey(clusterName) && this.states.get(clusterName).containsKey(serviceName) && this.states.get(clusterName).get(serviceName).equals((Object)serviceState) && serviceUpdateEvent.getMaintenanceState() == null) continue;
                this.states.computeIfAbsent(clusterName, c -> new HashMap()).put(serviceName, serviceState);
                serviceUpdateEvent.setState(serviceState);
            }
            eventBus.post((Object)serviceUpdateEvent);
        }
    }
}

