/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.events.publishers;

import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.EventBus;
import com.google.inject.Singleton;
import id.onyx.obdp.server.OBDPRuntimeException;
import id.onyx.obdp.server.events.DefaultMessageEmitter;
import id.onyx.obdp.server.events.STOMPEvent;
import id.onyx.obdp.server.events.publishers.BufferedUpdateEventPublisher;
import id.onyx.obdp.server.utils.ThreadPools;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class STOMPUpdatePublisher {
    private static final Logger LOG = LoggerFactory.getLogger(STOMPUpdatePublisher.class);
    private final EventBus agentEventBus;
    private final EventBus apiEventBus;
    private final List<BufferedUpdateEventPublisher> publishers = new ArrayList<BufferedUpdateEventPublisher>();

    public STOMPUpdatePublisher() {
        this.agentEventBus = new AsyncEventBus("agent-update-bus", (Executor)ThreadPools.getSingleThreadedExecutor("stomp-agent-bus"));
        this.apiEventBus = new AsyncEventBus("api-update-bus", (Executor)ThreadPools.getSingleThreadedExecutor("stomp-api-bus"));
    }

    public void registerPublisher(BufferedUpdateEventPublisher publisher) {
        if (this.publishers.contains(publisher)) {
            LOG.error("Publisher for type {} is already in use", (Object)publisher.getType());
        } else {
            this.publishers.add(publisher);
        }
    }

    public void publish(STOMPEvent event) {
        if (DefaultMessageEmitter.DEFAULT_AGENT_EVENT_TYPES.contains((Object)event.getType())) {
            this.publishAgent(event);
        } else if (DefaultMessageEmitter.DEFAULT_API_EVENT_TYPES.contains((Object)event.getType())) {
            this.publishAPI(event);
        } else {
            throw new OBDPRuntimeException("Event with type {" + event.getType() + "} can not be published.");
        }
    }

    private void publishAPI(STOMPEvent event) {
        boolean published = false;
        for (BufferedUpdateEventPublisher publisher : this.publishers) {
            if (!publisher.getType().equals((Object)event.getType())) continue;
            publisher.publish(event, this.apiEventBus);
            published = true;
        }
        if (!published) {
            this.apiEventBus.post((Object)event);
        }
    }

    private void publishAgent(STOMPEvent event) {
        this.agentEventBus.post((Object)event);
    }

    public void registerAgent(Object object) {
        this.agentEventBus.register(object);
    }

    public void registerAPI(Object object) {
        this.apiEventBus.register(object);
    }
}

