/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.events.publishers;

import com.google.common.eventbus.EventBus;
import com.google.inject.Inject;
import id.onyx.obdp.server.EagerSingleton;
import id.onyx.obdp.server.controller.internal.CalculatedStatus;
import id.onyx.obdp.server.events.RequestUpdateEvent;
import id.onyx.obdp.server.events.STOMPEvent;
import id.onyx.obdp.server.events.publishers.BufferedUpdateEventPublisher;
import id.onyx.obdp.server.events.publishers.STOMPUpdatePublisher;
import id.onyx.obdp.server.orm.dao.ClusterDAO;
import id.onyx.obdp.server.orm.dao.HostRoleCommandDAO;
import id.onyx.obdp.server.orm.dao.RequestDAO;
import id.onyx.obdp.server.orm.entities.RequestEntity;
import id.onyx.obdp.server.topology.TopologyManager;
import java.util.HashMap;
import java.util.List;

@EagerSingleton
public class RequestUpdateEventPublisher
extends BufferedUpdateEventPublisher<RequestUpdateEvent> {
    @Inject
    private HostRoleCommandDAO hostRoleCommandDAO;
    @Inject
    private TopologyManager topologyManager;
    @Inject
    private RequestDAO requestDAO;
    @Inject
    private ClusterDAO clusterDAO;

    @Inject
    public RequestUpdateEventPublisher(STOMPUpdatePublisher stompUpdatePublisher) {
        super(stompUpdatePublisher);
    }

    @Override
    public STOMPEvent.Type getType() {
        return STOMPEvent.Type.REQUEST;
    }

    @Override
    public void mergeBufferAndPost(List<RequestUpdateEvent> events, EventBus m_eventBus) {
        HashMap<Long, RequestUpdateEvent> filteredRequests = new HashMap<Long, RequestUpdateEvent>();
        for (RequestUpdateEvent event : events) {
            Long requestId = event.getRequestId();
            if (filteredRequests.containsKey(requestId)) {
                RequestUpdateEvent filteredRequest = (RequestUpdateEvent)filteredRequests.get(requestId);
                filteredRequest.setEndTime(event.getEndTime());
                filteredRequest.setRequestStatus(event.getRequestStatus());
                filteredRequest.setRequestContext(event.getRequestContext());
                filteredRequest.getHostRoleCommands().removeAll(event.getHostRoleCommands());
                filteredRequest.getHostRoleCommands().addAll(event.getHostRoleCommands());
                continue;
            }
            filteredRequests.put(requestId, event);
        }
        for (RequestUpdateEvent requestUpdateEvent : filteredRequests.values()) {
            RequestUpdateEvent filled = this.fillRequest(requestUpdateEvent);
            m_eventBus.post((Object)filled);
        }
    }

    private RequestUpdateEvent fillRequest(RequestUpdateEvent event) {
        event.setProgressPercent(CalculatedStatus.statusFromRequest(this.hostRoleCommandDAO, this.topologyManager, event.getRequestId()).getPercent());
        if (event.getEndTime() == null || event.getStartTime() == null || event.getClusterName() == null || event.getRequestContext() == null) {
            RequestEntity requestEntity = this.requestDAO.findByPK(event.getRequestId());
            event.setStartTime(requestEntity.getStartTime());
            event.setUserName(requestEntity.getUserName());
            event.setEndTime(requestEntity.getEndTime());
            if (requestEntity.getClusterId() != -1L) {
                event.setClusterName(this.clusterDAO.findById(requestEntity.getClusterId()).getClusterName());
            }
            event.setRequestContext(requestEntity.getRequestContext());
            event.setRequestStatus(requestEntity.getStatus());
        }
        return event;
    }
}

