/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.events.publishers;

import com.google.common.eventbus.EventBus;
import com.google.inject.Inject;
import id.onyx.obdp.server.EagerSingleton;
import id.onyx.obdp.server.events.HostComponentUpdate;
import id.onyx.obdp.server.events.HostComponentsUpdateEvent;
import id.onyx.obdp.server.events.STOMPEvent;
import id.onyx.obdp.server.events.publishers.BufferedUpdateEventPublisher;
import id.onyx.obdp.server.events.publishers.STOMPUpdatePublisher;
import java.util.List;
import java.util.stream.Collectors;

@EagerSingleton
public class HostComponentUpdateEventPublisher
extends BufferedUpdateEventPublisher<HostComponentsUpdateEvent> {
    @Inject
    public HostComponentUpdateEventPublisher(STOMPUpdatePublisher stompUpdatePublisher) {
        super(stompUpdatePublisher);
    }

    @Override
    public STOMPEvent.Type getType() {
        return STOMPEvent.Type.HOSTCOMPONENT;
    }

    @Override
    public void mergeBufferAndPost(List<HostComponentsUpdateEvent> events, EventBus m_eventBus) {
        List<HostComponentUpdate> hostComponentUpdates = events.stream().flatMap(u -> u.getHostComponentUpdates().stream()).collect(Collectors.toList());
        HostComponentsUpdateEvent resultEvents = new HostComponentsUpdateEvent(hostComponentUpdates);
        m_eventBus.post((Object)resultEvents);
    }
}

