/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.events.publishers;

import com.google.common.eventbus.EventBus;
import id.onyx.obdp.server.events.STOMPEvent;
import id.onyx.obdp.server.events.publishers.STOMPUpdatePublisher;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public abstract class BufferedUpdateEventPublisher<T> {
    private static final long TIMEOUT = 1000L;
    private final ConcurrentLinkedQueue<T> buffer = new ConcurrentLinkedQueue();
    private ScheduledExecutorService scheduledExecutorService;

    public abstract STOMPEvent.Type getType();

    public BufferedUpdateEventPublisher(STOMPUpdatePublisher stompUpdatePublisher) {
        stompUpdatePublisher.registerPublisher(this);
    }

    public void publish(T event, EventBus m_eventBus) {
        if (this.scheduledExecutorService == null) {
            this.scheduledExecutorService = Executors.newScheduledThreadPool(1);
            this.scheduledExecutorService.scheduleWithFixedDelay(this.getScheduledPublisher(m_eventBus), 1000L, 1000L, TimeUnit.MILLISECONDS);
        }
        this.buffer.add(event);
    }

    protected MergingRunnable getScheduledPublisher(EventBus m_eventBus) {
        return new MergingRunnable(m_eventBus);
    }

    protected List<T> retrieveBuffer() {
        ArrayList<T> bufferContent = new ArrayList<T>();
        while (!this.buffer.isEmpty()) {
            bufferContent.add(this.buffer.poll());
        }
        return bufferContent;
    }

    public abstract void mergeBufferAndPost(List<T> var1, EventBus var2);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BufferedUpdateEventPublisher that = (BufferedUpdateEventPublisher)o;
        return Objects.equals((Object)this.getType(), (Object)that.getType());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getType()});
    }

    private class MergingRunnable
    implements Runnable {
        private final EventBus m_eventBus;

        public MergingRunnable(EventBus m_eventBus) {
            this.m_eventBus = m_eventBus;
        }

        @Override
        public final void run() {
            List events = BufferedUpdateEventPublisher.this.retrieveBuffer();
            if (events.isEmpty()) {
                return;
            }
            BufferedUpdateEventPublisher.this.mergeBufferAndPost(events, this.m_eventBus);
        }
    }
}

