/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.events.publishers;

import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.EventBus;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.controller.utilities.ScalingThreadPoolExecutor;
import id.onyx.obdp.server.events.AlertEvent;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

@Singleton
public final class AlertEventPublisher {
    private final EventBus m_eventBus;

    @Inject
    public AlertEventPublisher(Configuration config) {
        int corePoolSize = config.getAlertEventPublisherCorePoolSize();
        int maxPoolSize = config.getAlertEventPublisherMaxPoolSize();
        int workerQueueSize = config.getAlertEventPublisherWorkerQueueSize();
        ScalingThreadPoolExecutor executor = new ScalingThreadPoolExecutor(corePoolSize, maxPoolSize, 0L, TimeUnit.SECONDS, workerQueueSize);
        executor.allowCoreThreadTimeOut(false);
        executor.setRejectedExecutionHandler(new ThreadPoolExecutor.DiscardOldestPolicy());
        executor.setThreadFactory(new AlertEventBusThreadFactory());
        this.m_eventBus = new AsyncEventBus((Executor)executor);
    }

    public void publish(AlertEvent event) {
        this.m_eventBus.post((Object)event);
    }

    public void register(Object object) {
        this.m_eventBus.register(object);
    }

    private static final class AlertEventBusThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger s_threadIdPool = new AtomicInteger(1);

        private AlertEventBusThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "alert-event-bus-" + s_threadIdPool.getAndIncrement());
            thread.setDaemon(false);
            thread.setPriority(4);
            return thread;
        }
    }
}

