/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.events.publishers;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.OBDPRuntimeException;
import id.onyx.obdp.server.agent.AgentCommand;
import id.onyx.obdp.server.agent.CancelCommand;
import id.onyx.obdp.server.agent.ExecutionCommand;
import id.onyx.obdp.server.agent.stomp.AgentConfigsHolder;
import id.onyx.obdp.server.agent.stomp.dto.ExecutionCommandsCluster;
import id.onyx.obdp.server.events.AgentConfigsUpdateEvent;
import id.onyx.obdp.server.events.ExecutionCommandEvent;
import id.onyx.obdp.server.events.publishers.STOMPUpdatePublisher;
import id.onyx.obdp.server.orm.dao.HostRoleCommandDAO;
import id.onyx.obdp.server.serveraction.kerberos.KerberosServerAction;
import id.onyx.obdp.server.serveraction.kerberos.stageutils.KerberosKeytabController;
import id.onyx.obdp.server.serveraction.kerberos.stageutils.ResolvedKerberosKeytab;
import id.onyx.obdp.server.serveraction.kerberos.stageutils.ResolvedKerberosPrincipal;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.DesiredConfig;
import id.onyx.obdp.server.state.kerberos.KerberosIdentityDescriptor;
import id.onyx.obdp.server.utils.StageUtils;
import id.onyx.obdp.server.utils.ThreadPools;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinTask;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AgentCommandsPublisher {
    private static final Logger LOG = LoggerFactory.getLogger(AgentCommandsPublisher.class);
    @Inject
    private KerberosKeytabController kerberosKeytabController;
    @Inject
    private Clusters clusters;
    @Inject
    private HostRoleCommandDAO hostRoleCommandDAO;
    @Inject
    private STOMPUpdatePublisher STOMPUpdatePublisher;
    @Inject
    private AgentConfigsHolder agentConfigsHolder;
    @Inject
    private ThreadPools threadPools;

    public void sendAgentCommand(Multimap<Long, AgentCommand> agentCommands) throws OBDPRuntimeException {
        if (agentCommands != null && !agentCommands.isEmpty()) {
            ConcurrentHashMap executionCommandsClusters = new ConcurrentHashMap();
            ConcurrentHashMap clusterDesiredConfigs = new ConcurrentHashMap();
            try {
                ((ForkJoinTask)this.threadPools.getAgentPublisherCommandsPool().submit(() -> ((Stream)agentCommands.entries().stream().parallel()).forEach(acHostEntry -> {
                    Long hostId = (Long)acHostEntry.getKey();
                    AgentCommand ac = (AgentCommand)acHostEntry.getValue();
                    Long clusterId = null;
                    if (ac instanceof ExecutionCommand) {
                        try {
                            clusterId = Long.valueOf(((ExecutionCommand)ac).getClusterId());
                            if (clusterId >= 0L) {
                                if (!clusterDesiredConfigs.containsKey(clusterId)) {
                                    clusterDesiredConfigs.put(clusterId, this.clusters.getCluster(clusterId).getDesiredConfigs());
                                }
                            } else {
                                LOG.warn("The cluster not found or has not been created yet. clusterID={}.", (Object)clusterId);
                            }
                        }
                        catch (OBDPException | NumberFormatException e) {
                            LOG.error("Exception on sendAgentCommand", e);
                        }
                    }
                    Map desiredConfigs = clusterId != null && clusterDesiredConfigs.containsKey(clusterId) ? (Map)clusterDesiredConfigs.get(clusterId) : null;
                    this.populateExecutionCommandsClusters(executionCommandsClusters, hostId, ac, desiredConfigs);
                }))).get();
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.error("Exception on sendAgentCommand", (Throwable)e);
            }
            try {
                ((ForkJoinTask)this.threadPools.getAgentPublisherCommandsPool().submit(() -> ((Stream)executionCommandsClusters.entrySet().stream().parallel()).forEach(entry -> this.STOMPUpdatePublisher.publish(new ExecutionCommandEvent((Long)entry.getKey(), ((AgentConfigsUpdateEvent)this.agentConfigsHolder.initializeDataIfNeeded((Long)entry.getKey(), true)).getTimestamp(), (TreeMap)entry.getValue()))))).get();
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.error("Exception on sendAgentCommand", (Throwable)e);
            }
        }
    }

    public void sendAgentCommand(Long hostId, AgentCommand agentCommand) throws OBDPRuntimeException {
        ArrayListMultimap agentCommands = ArrayListMultimap.create();
        agentCommands.put((Object)hostId, (Object)agentCommand);
        this.sendAgentCommand((Multimap<Long, AgentCommand>)agentCommands);
    }

    private void populateExecutionCommandsClusters(Map<Long, TreeMap<String, ExecutionCommandsCluster>> executionCommandsClusters, Long hostId, AgentCommand ac, @Nullable Map<String, DesiredConfig> desiredConfigs) throws OBDPRuntimeException {
        if (LOG.isDebugEnabled()) {
            try {
                LOG.debug("Sending command string = " + StageUtils.jaxbToString(ac));
            }
            catch (Exception e) {
                throw new OBDPRuntimeException("Could not get jaxb string for command", e);
            }
        }
        switch (ac.getCommandType()) {
            case BACKGROUND_EXECUTION_COMMAND: 
            case EXECUTION_COMMAND: {
                String customCommand;
                ExecutionCommand ec = (ExecutionCommand)ac;
                LOG.info("AgentCommandsPublisher.sendCommands: sending ExecutionCommand for host {}, role {}, roleCommand {}, and command ID {}, task ID {}", new Object[]{ec.getHostname(), ec.getRole(), ec.getRoleCommand(), ec.getCommandId(), ec.getTaskId()});
                Map<String, String> hlp = ec.getCommandParams();
                if (hlp != null && ("SET_KEYTAB".equalsIgnoreCase(customCommand = hlp.get("custom_command")) || "REMOVE_KEYTAB".equalsIgnoreCase(customCommand) || "CHECK_KEYTABS".equalsIgnoreCase(customCommand))) {
                    LOG.info(String.format("%s called", customCommand));
                    try {
                        this.injectKeytab(ec, customCommand, this.clusters.getHostById(hostId).getHostName(), desiredConfigs);
                    }
                    catch (IOException e) {
                        throw new OBDPRuntimeException("Could not inject keytab into command", e);
                    }
                }
                String clusterName = ec.getClusterName();
                String clusterId = "-1";
                if (clusterName != null) {
                    try {
                        clusterId = Long.toString(this.clusters.getCluster(clusterName).getClusterId());
                    }
                    catch (OBDPException e) {
                        throw new OBDPRuntimeException(e);
                    }
                }
                ec.setClusterId(clusterId);
                this.prepareExecutionCommandsClusters(executionCommandsClusters, hostId, clusterId);
                executionCommandsClusters.get(hostId).get(clusterId).getExecutionCommands().add((ExecutionCommand)ac);
                break;
            }
            case CANCEL_COMMAND: {
                CancelCommand cc = (CancelCommand)ac;
                String clusterId = Long.toString(this.hostRoleCommandDAO.findByPK(cc.getTargetTaskId()).getStage().getClusterId());
                this.prepareExecutionCommandsClusters(executionCommandsClusters, hostId, clusterId);
                executionCommandsClusters.get(hostId).get(clusterId).getCancelCommands().add(cc);
                break;
            }
            default: {
                LOG.error("There is no action for agent command =" + ac.getCommandType().name());
            }
        }
    }

    private void prepareExecutionCommandsClusters(Map<Long, TreeMap<String, ExecutionCommandsCluster>> executionCommandsClusters, Long hostId, String clusterId) {
        if (!executionCommandsClusters.containsKey(hostId)) {
            executionCommandsClusters.put(hostId, new TreeMap());
        }
        if (!executionCommandsClusters.get(hostId).containsKey(clusterId)) {
            executionCommandsClusters.get(hostId).put(clusterId, new ExecutionCommandsCluster(new ArrayList<ExecutionCommand>(), new ArrayList<CancelCommand>()));
        }
    }

    private void injectKeytab(ExecutionCommand ec, String command, String targetHost, @Nullable Map<String, DesiredConfig> desiredConfigs) throws OBDPException {
        KerberosCommandParameterProcessor processor = KerberosCommandParameterProcessor.getInstance(command, this.clusters, ec, this.kerberosKeytabController);
        if (processor != null) {
            ec.setKerberosCommandParams(processor.process(targetHost, desiredConfigs));
        }
    }

    private static abstract class KerberosCommandParameterProcessor {
        protected final Clusters clusters;
        protected final ExecutionCommand executionCommand;
        protected final KerberosKeytabController kerberosKeytabController;
        protected List<Map<String, String>> kcp;

        protected KerberosCommandParameterProcessor(Clusters clusters, ExecutionCommand executionCommand, KerberosKeytabController kerberosKeytabController) {
            this.clusters = clusters;
            this.executionCommand = executionCommand;
            this.kerberosKeytabController = kerberosKeytabController;
            this.kcp = executionCommand.getKerberosCommandParams();
        }

        public static KerberosCommandParameterProcessor getInstance(String command, Clusters clusters, ExecutionCommand executionCommand, KerberosKeytabController kerberosKeytabController) {
            if ("SET_KEYTAB".equalsIgnoreCase(command)) {
                return new SetKeytabCommandParameterProcessor(clusters, executionCommand, kerberosKeytabController);
            }
            if ("CHECK_KEYTABS".equalsIgnoreCase(command)) {
                return new CheckKeytabsCommandParameterProcessor(clusters, executionCommand, kerberosKeytabController);
            }
            if ("REMOVE_KEYTAB".equalsIgnoreCase(command)) {
                return new RemoveKeytabCommandParameterProcessor(clusters, executionCommand, kerberosKeytabController);
            }
            return null;
        }

        public List<Map<String, String>> process(String targetHost, @Nullable Map<String, DesiredConfig> desiredConfigs) throws OBDPException {
            KerberosServerAction.KerberosCommandParameters kerberosCommandParameters = new KerberosServerAction.KerberosCommandParameters(this.executionCommand);
            Map<String, ? extends Collection<String>> serviceComponentFilter = this.getServiceComponentFilter(kerberosCommandParameters.getServiceComponentFilter());
            Collection<KerberosIdentityDescriptor> serviceIdentities = serviceComponentFilter == null ? null : this.kerberosKeytabController.getServiceIdentities(this.executionCommand.getClusterName(), serviceComponentFilter.keySet(), desiredConfigs);
            Set<ResolvedKerberosKeytab> keytabsToInject = this.kerberosKeytabController.getFilteredKeytabs(serviceIdentities, kerberosCommandParameters.getHostFilter(), kerberosCommandParameters.getIdentityFilter());
            keytabsToInject.forEach(resolvedKeytab -> resolvedKeytab.getPrincipals().forEach(resolvedPrincipal -> {
                String hostName = resolvedPrincipal.getHostName();
                if (targetHost.equalsIgnoreCase(hostName)) {
                    try {
                        this.process(targetHost, (ResolvedKerberosKeytab)resolvedKeytab, (ResolvedKerberosPrincipal)resolvedPrincipal, serviceComponentFilter);
                    }
                    catch (IOException e) {
                        throw new OBDPRuntimeException("Could not inject keytabs to enable kerberos", e);
                    }
                }
            }));
            return this.kcp;
        }

        protected void process(String hostName, ResolvedKerberosKeytab resolvedKeytab, ResolvedKerberosPrincipal resolvedPrincipal, Map<String, ? extends Collection<String>> serviceComponentFilter) throws IOException {
            HashMap<String, String> keytabMap = new HashMap<String, String>();
            keytabMap.put("hostname", hostName);
            keytabMap.put("principal", resolvedPrincipal.getPrincipal());
            keytabMap.put("keytab_file_path", resolvedKeytab.getFile());
            this.kcp.add(keytabMap);
        }

        protected Map<String, ? extends Collection<String>> getServiceComponentFilter(Map<String, ? extends Collection<String>> serviceComponentFilter) throws OBDPException {
            return serviceComponentFilter;
        }
    }

    private static class RemoveKeytabCommandParameterProcessor
    extends KerberosCommandParameterProcessor {
        private RemoveKeytabCommandParameterProcessor(Clusters clusters, ExecutionCommand executionCommand, KerberosKeytabController kerberosKeytabController) {
            super(clusters, executionCommand, kerberosKeytabController);
        }

        @Override
        protected void process(String hostName, ResolvedKerberosKeytab resolvedKeytab, ResolvedKerberosPrincipal resolvedPrincipal, Map<String, ? extends Collection<String>> serviceComponentFilter) throws IOException {
            if (this.shouldRemove(hostName, resolvedKeytab, resolvedPrincipal, serviceComponentFilter)) {
                super.process(hostName, resolvedKeytab, resolvedPrincipal, serviceComponentFilter);
            }
        }

        private boolean shouldRemove(String hostname, ResolvedKerberosKeytab resolvedKerberosKeytab, ResolvedKerberosPrincipal resolvedPrincipal, Map<String, ? extends Collection<String>> serviceComponentFilter) {
            ResolvedKerberosKeytab existingResolvedKeytab = this.kerberosKeytabController.getKeytabByFile(resolvedKerberosKeytab.getFile());
            if (existingResolvedKeytab == null) {
                return true;
            }
            Set<ResolvedKerberosPrincipal> principals = existingResolvedKeytab.getPrincipals();
            for (ResolvedKerberosPrincipal principal : principals) {
                HashMap serviceMapping;
                if (!hostname.equals(principal.getHostName()) || !principal.getPrincipal().equals(resolvedPrincipal.getPrincipal())) continue;
                Multimap<String, String> temp = principal.getServiceMapping();
                HashMap<String, HashSet<Object>> hashMap = serviceMapping = temp == null ? new HashMap() : new HashMap(temp.asMap());
                if (serviceComponentFilter == null) {
                    serviceMapping.clear();
                } else {
                    for (Map.Entry<String, ? extends Collection<String>> entry : serviceComponentFilter.entrySet()) {
                        String service = entry.getKey();
                        Collection<String> components = entry.getValue();
                        if (!serviceMapping.containsKey(service)) continue;
                        if (CollectionUtils.isEmpty(components) || CollectionUtils.isEmpty((Collection)((Collection)serviceMapping.get(service)))) {
                            serviceMapping.remove(service);
                            continue;
                        }
                        HashSet leftOver = new HashSet((Collection)serviceMapping.get(service));
                        leftOver.removeAll(components);
                        if (CollectionUtils.isEmpty(leftOver)) {
                            serviceMapping.remove(service);
                            continue;
                        }
                        serviceMapping.put(service, leftOver);
                    }
                }
                if (serviceMapping.size() <= 0) continue;
                return false;
            }
            return true;
        }
    }

    private static class CheckKeytabsCommandParameterProcessor
    extends KerberosCommandParameterProcessor {
        private CheckKeytabsCommandParameterProcessor(Clusters clusters, ExecutionCommand executionCommand, KerberosKeytabController kerberosKeytabController) {
            super(clusters, executionCommand, kerberosKeytabController);
        }
    }

    private static class SetKeytabCommandParameterProcessor
    extends KerberosCommandParameterProcessor {
        private final String dataDir;

        private SetKeytabCommandParameterProcessor(Clusters clusters, ExecutionCommand executionCommand, KerberosKeytabController kerberosKeytabController) {
            super(clusters, executionCommand, kerberosKeytabController);
            this.dataDir = executionCommand.getCommandParams().get("data_directory");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void process(String hostName, ResolvedKerberosKeytab resolvedKeytab, ResolvedKerberosPrincipal resolvedPrincipal, Map<String, ? extends Collection<String>> serviceComponentFilter) throws IOException {
            if (this.dataDir != null) {
                String principal = resolvedPrincipal.getPrincipal();
                String keytabFilePath = resolvedKeytab.getFile();
                LOG.info("Processing principal {} for host {} and keytab file path {}", new Object[]{principal, hostName, keytabFilePath});
                if (keytabFilePath != null) {
                    String sha1Keytab = DigestUtils.sha256Hex((String)keytabFilePath);
                    File keytabFile = Paths.get(this.dataDir, hostName, sha1Keytab).toFile();
                    if (keytabFile.canRead()) {
                        byte[] keytabContent;
                        HashMap<String, String> keytabMap = new HashMap<String, String>();
                        keytabMap.put("hostname", hostName);
                        keytabMap.put("principal", principal);
                        keytabMap.put("keytab_file_path", keytabFilePath);
                        keytabMap.put("keytab_file_owner_name", resolvedKeytab.getOwnerName());
                        keytabMap.put("keytab_file_owner_access", resolvedKeytab.getOwnerAccess());
                        keytabMap.put("keytab_file_group_name", resolvedKeytab.getGroupName());
                        keytabMap.put("keytab_file_group_access", resolvedKeytab.getGroupAccess());
                        try (BufferedInputStream bufferedIn = new BufferedInputStream(new FileInputStream(keytabFile));){
                            keytabContent = IOUtils.toByteArray((InputStream)bufferedIn);
                        }
                        String keytabContentBase64 = Base64.encodeBase64String((byte[])keytabContent);
                        keytabMap.put("keytab_content_base64", keytabContentBase64);
                        this.kcp.add(keytabMap);
                    } else {
                        LOG.warn("Keytab file for principal {} and host {} can not to be read at path {}", new Object[]{principal, hostName, keytabFile.getAbsolutePath()});
                    }
                }
            }
        }

        @Override
        protected Map<String, ? extends Collection<String>> getServiceComponentFilter(Map<String, ? extends Collection<String>> serviceComponentFilter) throws OBDPException {
            return this.kerberosKeytabController.adjustServiceComponentFilter(this.clusters.getCluster(this.executionCommand.getClusterName()), false, serviceComponentFilter);
        }
    }
}

