/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.events.listeners.upgrade;

import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import id.onyx.obdp.server.EagerSingleton;
import id.onyx.obdp.server.events.RequestUpdateEvent;
import id.onyx.obdp.server.events.UpgradeUpdateEvent;
import id.onyx.obdp.server.events.publishers.STOMPUpdatePublisher;
import id.onyx.obdp.server.orm.dao.HostRoleCommandDAO;
import id.onyx.obdp.server.orm.dao.RequestDAO;
import id.onyx.obdp.server.orm.dao.UpgradeDAO;
import id.onyx.obdp.server.orm.entities.UpgradeEntity;

@Singleton
@EagerSingleton
public class UpgradeUpdateListener {
    private STOMPUpdatePublisher STOMPUpdatePublisher;
    @Inject
    private UpgradeDAO upgradeDAO;
    @Inject
    private HostRoleCommandDAO hostRoleCommandDAO;
    @Inject
    private RequestDAO requestDAO;

    @Inject
    public UpgradeUpdateListener(STOMPUpdatePublisher STOMPUpdatePublisher2) {
        STOMPUpdatePublisher2.registerAPI(this);
        this.STOMPUpdatePublisher = STOMPUpdatePublisher2;
    }

    @Subscribe
    public void onRequestUpdate(RequestUpdateEvent requestUpdateEvent) {
        UpgradeEntity upgradeEntity = this.upgradeDAO.findUpgradeByRequestId(requestUpdateEvent.getRequestId());
        if (upgradeEntity != null) {
            this.STOMPUpdatePublisher.publish(UpgradeUpdateEvent.formUpdateEvent(this.hostRoleCommandDAO, this.requestDAO, upgradeEntity));
        }
    }
}

