/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.events.listeners.upgrade;

import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import id.onyx.obdp.server.EagerSingleton;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.agent.stomp.HostLevelParamsHolder;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.events.HostComponentVersionAdvertisedEvent;
import id.onyx.obdp.server.events.publishers.VersionEventPublisher;
import id.onyx.obdp.server.orm.dao.RepositoryVersionDAO;
import id.onyx.obdp.server.orm.entities.RepositoryVersionEntity;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.ComponentInfo;
import id.onyx.obdp.server.state.ServiceComponent;
import id.onyx.obdp.server.state.ServiceComponentHost;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.server.state.State;
import id.onyx.obdp.server.state.UpgradeState;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@EagerSingleton
public class StackVersionListener {
    private static final Logger LOG = LoggerFactory.getLogger(StackVersionListener.class);
    public static final String UNKNOWN_VERSION = State.UNKNOWN.toString();
    @Inject
    private RepositoryVersionDAO repositoryVersionDAO;
    private Provider<OBDPMetaInfo> ambariMetaInfoProvider;
    private final Provider<HostLevelParamsHolder> m_hostLevelParamsHolder;

    @Inject
    public StackVersionListener(VersionEventPublisher eventPublisher, Provider<OBDPMetaInfo> ambariMetaInfoProvider, Provider<HostLevelParamsHolder> m_hostLevelParamsHolder) {
        this.ambariMetaInfoProvider = ambariMetaInfoProvider;
        this.m_hostLevelParamsHolder = m_hostLevelParamsHolder;
        eventPublisher.register(this);
    }

    @Subscribe
    public void onAmbariEvent(HostComponentVersionAdvertisedEvent event) {
        RepositoryVersionEntity rve;
        LOG.debug("Received event {}", (Object)event);
        Cluster cluster = event.getCluster();
        ServiceComponentHost sch = event.getServiceComponentHost();
        String newVersion = event.getVersion();
        if (StringUtils.isEmpty((String)newVersion)) {
            return;
        }
        if (null != event.getRepositoryVersionId() && null == cluster.getUpgradeInProgress() && null != (rve = (RepositoryVersionEntity)this.repositoryVersionDAO.findByPK(event.getRepositoryVersionId()))) {
            String currentRepoVersion = rve.getVersion();
            if (!StringUtils.equals((String)currentRepoVersion, (String)newVersion)) {
                rve.setVersion(newVersion);
                rve.setResolved(false);
            }
            if (!rve.isResolved()) {
                rve.setResolved(true);
                this.repositoryVersionDAO.merge(rve);
            }
        }
        try {
            StackId desiredStackId = sch.getDesiredStackId();
            OBDPMetaInfo obdpMetaInfo = (OBDPMetaInfo)this.ambariMetaInfoProvider.get();
            ComponentInfo componentInfo = obdpMetaInfo.getComponent(desiredStackId.getStackName(), desiredStackId.getStackVersion(), sch.getServiceName(), sch.getServiceComponentName());
            if (!componentInfo.isVersionAdvertised()) {
                if (!StringUtils.equalsIgnoreCase((String)UNKNOWN_VERSION, (String)newVersion)) {
                    LOG.warn("ServiceComponent {} doesn't advertise version, however ServiceHostComponent {} on host {} advertised version as {}. Skipping version update", new Object[]{sch.getServiceComponentName(), sch.getServiceComponentName(), sch.getHostName(), newVersion});
                }
                return;
            }
            ServiceComponent sc = cluster.getService(sch.getServiceName()).getServiceComponent(sch.getServiceComponentName());
            if (StringUtils.equalsIgnoreCase((String)UNKNOWN_VERSION, (String)newVersion)) {
                this.processUnknownDesiredVersion(cluster, sc, sch, newVersion);
                return;
            }
            this.processComponentAdvertisedVersion(cluster, sc, sch, newVersion);
        }
        catch (Exception e) {
            LOG.error("Unable to propagate version for ServiceHostComponent on component: {}, host: {}. Error: {}", new Object[]{sch.getServiceComponentName(), sch.getHostName(), e.getMessage()});
        }
    }

    private void processComponentAdvertisedVersion(Cluster cluster, ServiceComponent sc, ServiceComponentHost sch, String newVersion) throws OBDPException {
        if (StringUtils.isBlank((String)newVersion)) {
            return;
        }
        String previousVersion = sch.getVersion();
        String desiredVersion = sc.getDesiredVersion();
        UpgradeState upgradeState = sch.getUpgradeState();
        boolean versionIsCorrect = StringUtils.equals((String)desiredVersion, (String)newVersion);
        if (!StringUtils.equals((String)previousVersion, (String)newVersion)) {
            sch.setVersion(newVersion);
        }
        if (previousVersion == null || StringUtils.equalsIgnoreCase((String)UNKNOWN_VERSION, (String)previousVersion)) {
            sch.setUpgradeState(UpgradeState.NONE);
            sch.recalculateHostVersionState();
        } else if (versionIsCorrect) {
            boolean isUpgradeInProgressForThisComponent;
            boolean bl = isUpgradeInProgressForThisComponent = null != cluster.getUpgradeInProgress() && upgradeState != UpgradeState.NONE;
            if (isUpgradeInProgressForThisComponent) {
                this.setUpgradeStateAndRecalculateHostVersions(sch, UpgradeState.COMPLETE);
            } else {
                this.setUpgradeStateAndRecalculateHostVersions(sch, UpgradeState.NONE);
            }
        } else {
            this.setUpgradeStateAndRecalculateHostVersions(sch, UpgradeState.VERSION_MISMATCH);
        }
        sc.updateRepositoryState(newVersion);
    }

    private void processUnknownDesiredVersion(Cluster cluster, ServiceComponent sc, ServiceComponentHost sch, String newVersion) throws OBDPException {
        sch.setUpgradeState(UpgradeState.NONE);
        sch.setVersion(newVersion);
        sch.recalculateHostVersionState();
    }

    private void setUpgradeStateAndRecalculateHostVersions(ServiceComponentHost sch, UpgradeState upgradeState) throws OBDPException {
        if (sch.getUpgradeState() == upgradeState) {
            return;
        }
        sch.setUpgradeState(upgradeState);
        sch.recalculateHostVersionState();
    }
}

