/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.events.listeners.upgrade;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import id.onyx.obdp.server.EagerSingleton;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.events.StackUpgradeFinishEvent;
import id.onyx.obdp.server.events.publishers.VersionEventPublisher;
import id.onyx.obdp.server.metadata.CachedRoleCommandOrderProvider;
import id.onyx.obdp.server.metadata.RoleCommandOrderProvider;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Service;
import id.onyx.obdp.server.state.ServiceComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@EagerSingleton
public class StackUpgradeFinishListener {
    private static final Logger LOG = LoggerFactory.getLogger(StackUpgradeFinishListener.class);
    @Inject
    Provider<OBDPMetaInfo> obdpMetaInfo;
    @Inject
    Provider<RoleCommandOrderProvider> roleCommandOrderProvider;

    @Inject
    public StackUpgradeFinishListener(VersionEventPublisher eventPublisher) {
        eventPublisher.register(this);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onAmbariEvent(StackUpgradeFinishEvent event) {
        LOG.debug("Received event {}", (Object)event);
        Cluster cluster = event.getCluster();
        for (Service service : cluster.getServices().values()) {
            try {
                service.updateServiceInfo();
                for (ServiceComponent sc : service.getServiceComponents().values()) {
                    sc.updateComponentInfo();
                }
            }
            catch (OBDPException e) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error("Caught OBDPException when update component info", (Throwable)e);
            }
        }
        if (this.roleCommandOrderProvider.get() instanceof CachedRoleCommandOrderProvider) {
            LOG.info("Clearing RCO cache");
            CachedRoleCommandOrderProvider cachedRcoProvider = (CachedRoleCommandOrderProvider)this.roleCommandOrderProvider.get();
            cachedRcoProvider.clearRoleCommandOrderCache();
        }
        try {
            ((OBDPMetaInfo)this.obdpMetaInfo.get()).reconcileAlertDefinitions(cluster, true);
        }
        catch (OBDPException e) {
            LOG.error("Caught OBDPException when update alert definitions", (Throwable)e);
        }
    }
}

