/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.events.listeners.upgrade;

import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.EagerSingleton;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.events.HostsAddedEvent;
import id.onyx.obdp.server.events.HostsRemovedEvent;
import id.onyx.obdp.server.events.ServiceComponentInstalledEvent;
import id.onyx.obdp.server.events.ServiceComponentUninstalledEvent;
import id.onyx.obdp.server.events.ServiceInstalledEvent;
import id.onyx.obdp.server.events.publishers.OBDPEventPublisher;
import id.onyx.obdp.server.logging.LockFactory;
import id.onyx.obdp.server.orm.dao.HostDAO;
import id.onyx.obdp.server.orm.dao.HostVersionDAO;
import id.onyx.obdp.server.orm.dao.RepositoryVersionDAO;
import id.onyx.obdp.server.orm.entities.HostComponentDesiredStateEntity;
import id.onyx.obdp.server.orm.entities.HostEntity;
import id.onyx.obdp.server.orm.entities.HostVersionEntity;
import id.onyx.obdp.server.orm.entities.RepositoryVersionEntity;
import id.onyx.obdp.server.orm.entities.StackEntity;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.ComponentInfo;
import id.onyx.obdp.server.state.RepositoryVersionState;
import id.onyx.obdp.server.state.Service;
import id.onyx.obdp.server.state.ServiceComponent;
import id.onyx.obdp.server.state.StackId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@EagerSingleton
public class HostVersionOutOfSyncListener {
    private static final Logger LOG = LoggerFactory.getLogger(HostVersionOutOfSyncListener.class);
    @Inject
    private Provider<HostVersionDAO> hostVersionDAO;
    @Inject
    private Provider<HostDAO> hostDAO;
    @Inject
    private Provider<Clusters> clusters;
    @Inject
    private Provider<OBDPMetaInfo> ami;
    @Inject
    private Provider<RepositoryVersionDAO> repositoryVersionDAO;
    private final Lock m_lock;

    @Inject
    public HostVersionOutOfSyncListener(OBDPEventPublisher ambariEventPublisher, LockFactory lockFactory) {
        ambariEventPublisher.register(this);
        this.m_lock = lockFactory.newLock("hostVersionOutOfSyncListenerLock");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Subscribe
    @Transactional
    public void onServiceComponentEvent(ServiceComponentInstalledEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(event.toString());
        }
        this.m_lock.lock();
        try {
            Cluster cluster = ((Clusters)this.clusters.get()).getClusterById(event.getClusterId());
            List<HostVersionEntity> hostVersionEntities = ((HostVersionDAO)this.hostVersionDAO.get()).findByClusterAndHost(cluster.getClusterName(), event.getHostName());
            Service service = cluster.getService(event.getServiceName());
            ServiceComponent serviceComponent = service.getServiceComponent(event.getComponentName());
            RepositoryVersionEntity componentRepo = serviceComponent.getDesiredRepositoryVersion();
            for (HostVersionEntity hostVersionEntity : hostVersionEntities) {
                StackEntity hostStackEntity = hostVersionEntity.getRepositoryVersion().getStack();
                StackId hostStackId = new StackId(hostStackEntity);
                String serviceName = event.getServiceName();
                String componentName = event.getComponentName();
                if (!((OBDPMetaInfo)this.ami.get()).isValidServiceComponent(hostStackId.getStackName(), hostStackId.getStackVersion(), serviceName, componentName)) {
                    LOG.debug("Component not found is host stack, stack={}, version={}, service={}, component={}", new Object[]{hostStackId.getStackName(), hostStackId.getStackVersion(), serviceName, componentName});
                    continue;
                }
                ComponentInfo component = ((OBDPMetaInfo)this.ami.get()).getComponent(hostStackId.getStackName(), hostStackId.getStackVersion(), serviceName, componentName);
                if (!component.isVersionAdvertised()) {
                    RepositoryVersionState state = this.checkAllHostComponents(hostStackId, hostVersionEntity.getHostEntity());
                    if (null == state) continue;
                    hostVersionEntity.setState(state);
                    ((HostVersionDAO)this.hostVersionDAO.get()).merge(hostVersionEntity);
                    continue;
                }
                if (!hostVersionEntity.getRepositoryVersion().equals(componentRepo)) continue;
                switch (hostVersionEntity.getState()) {
                    case INSTALLED: 
                    case NOT_REQUIRED: {
                        hostVersionEntity.setState(RepositoryVersionState.OUT_OF_SYNC);
                        ((HostVersionDAO)this.hostVersionDAO.get()).merge(hostVersionEntity);
                        break;
                    }
                }
            }
        }
        catch (OBDPException e) {
            LOG.error("Can not update hosts about out of sync", (Throwable)e);
        }
        finally {
            this.m_lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Subscribe
    @Transactional
    public void onServiceComponentHostEvent(ServiceComponentUninstalledEvent event) {
        this.m_lock.lock();
        try {
            Cluster cluster = ((Clusters)this.clusters.get()).getClusterById(event.getClusterId());
            List<HostVersionEntity> hostVersionEntities = ((HostVersionDAO)this.hostVersionDAO.get()).findByClusterAndHost(cluster.getClusterName(), event.getHostName());
            for (HostVersionEntity hostVersionEntity : hostVersionEntities) {
                HostEntity hostEntity = hostVersionEntity.getHostEntity();
                RepositoryVersionEntity repoVersionEntity = hostVersionEntity.getRepositoryVersion();
                StackId stackId = repoVersionEntity.getStackId();
                if (null == stackId) {
                    LOG.info("Stack id could not be loaded for host version {}, repo {}", (Object)hostVersionEntity.getHostName(), (Object)repoVersionEntity.getVersion());
                    continue;
                }
                RepositoryVersionState repoState = this.checkAllHostComponents(stackId, hostEntity);
                if (null == repoState) continue;
                hostVersionEntity.setState(repoState);
                ((HostVersionDAO)this.hostVersionDAO.get()).merge(hostVersionEntity);
            }
        }
        catch (OBDPException e) {
            LOG.error("Cannot update states after a component was uninstalled: {}", (Object)event, (Object)e);
        }
        finally {
            this.m_lock.unlock();
        }
    }

    private RepositoryVersionState checkAllHostComponents(StackId stackId, HostEntity host) throws OBDPException {
        Collection<HostComponentDesiredStateEntity> hostComponents = host.getHostComponentDesiredStateEntities();
        for (HostComponentDesiredStateEntity hostComponent : hostComponents) {
            if (!((OBDPMetaInfo)this.ami.get()).isValidServiceComponent(stackId.getStackName(), stackId.getStackVersion(), hostComponent.getServiceName(), hostComponent.getComponentName())) {
                LOG.debug("Component not found is host stack, stack={}, version={}, service={}, component={}", new Object[]{stackId.getStackName(), stackId.getStackVersion(), hostComponent.getServiceName(), hostComponent.getComponentName()});
                continue;
            }
            ComponentInfo ci = ((OBDPMetaInfo)this.ami.get()).getComponent(stackId.getStackName(), stackId.getStackVersion(), hostComponent.getServiceName(), hostComponent.getComponentName());
            if (!ci.isVersionAdvertised()) continue;
            return null;
        }
        return RepositoryVersionState.NOT_REQUIRED;
    }

    @Subscribe
    @Transactional
    public void onServiceEvent(ServiceInstalledEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(event.toString());
        }
        try {
            Cluster cluster = ((Clusters)this.clusters.get()).getClusterById(event.getClusterId());
            Map<String, ServiceComponent> serviceComponents = cluster.getService(event.getServiceName()).getServiceComponents();
            HashMap affectedHosts = new HashMap();
            for (ServiceComponent component : serviceComponents.values()) {
                for (String hostname : component.getServiceComponentHosts().keySet()) {
                    if (!affectedHosts.containsKey(hostname)) {
                        affectedHosts.put(hostname, new ArrayList());
                    }
                    ((List)affectedHosts.get(hostname)).add(component);
                }
            }
            for (String hostName : affectedHosts.keySet()) {
                List<HostVersionEntity> hostVersionEntities = ((HostVersionDAO)this.hostVersionDAO.get()).findByClusterAndHost(cluster.getClusterName(), hostName);
                for (HostVersionEntity hostVersionEntity : hostVersionEntities) {
                    RepositoryVersionEntity repositoryVersion = hostVersionEntity.getRepositoryVersion();
                    boolean hasChangedComponentsWithVersions = false;
                    String serviceName = event.getServiceName();
                    for (ServiceComponent comp : (List)affectedHosts.get(hostName)) {
                        String componentName = comp.getName();
                        if (!((OBDPMetaInfo)this.ami.get()).isValidServiceComponent(repositoryVersion.getStackName(), repositoryVersion.getStackVersion(), serviceName, componentName)) {
                            LOG.debug("Component not found is host stack, stack={}, version={}, service={}, component={}", new Object[]{repositoryVersion.getStackName(), repositoryVersion.getStackVersion(), serviceName, componentName});
                            continue;
                        }
                        ComponentInfo component = ((OBDPMetaInfo)this.ami.get()).getComponent(repositoryVersion.getStackName(), repositoryVersion.getStackVersion(), serviceName, componentName);
                        if (!component.isVersionAdvertised()) continue;
                        hasChangedComponentsWithVersions = true;
                    }
                    if (!hasChangedComponentsWithVersions || !hostVersionEntity.getState().equals((Object)RepositoryVersionState.INSTALLED)) continue;
                    hostVersionEntity.setState(RepositoryVersionState.OUT_OF_SYNC);
                    ((HostVersionDAO)this.hostVersionDAO.get()).merge(hostVersionEntity);
                }
            }
        }
        catch (OBDPException e) {
            LOG.error("Can not update hosts about out of sync", (Throwable)e);
        }
    }

    @Subscribe
    @Transactional
    public void onHostEvent(HostsAddedEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(event.toString());
        }
        List repos = ((RepositoryVersionDAO)this.repositoryVersionDAO.get()).findAll();
        for (String hostName : event.getHostNames()) {
            HostEntity hostEntity = ((HostDAO)this.hostDAO.get()).findByName(hostName);
            for (RepositoryVersionEntity repositoryVersion : repos) {
                HostVersionEntity missingHostVersion = new HostVersionEntity(hostEntity, repositoryVersion, RepositoryVersionState.NOT_REQUIRED);
                LOG.info("Creating host version for {}, state={}, repo={} (repo_id={})", new Object[]{missingHostVersion.getHostName(), missingHostVersion.getState(), missingHostVersion.getRepositoryVersion().getVersion(), missingHostVersion.getRepositoryVersion().getId()});
                ((HostVersionDAO)this.hostVersionDAO.get()).create(missingHostVersion);
                ((HostDAO)this.hostDAO.get()).merge(hostEntity);
                hostEntity.getHostVersionEntities().add(missingHostVersion);
                hostEntity = ((HostDAO)this.hostDAO.get()).merge(hostEntity);
            }
        }
    }

    @Subscribe
    @Transactional
    public void onHostEvent(HostsRemovedEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(event.toString());
        }
    }
}

