/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.events.listeners.upgrade;

import com.google.common.eventbus.Subscribe;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.SerializedName;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import id.onyx.obdp.server.EagerSingleton;
import id.onyx.obdp.server.actionmanager.HostRoleStatus;
import id.onyx.obdp.server.events.ActionFinalReportReceivedEvent;
import id.onyx.obdp.server.events.publishers.OBDPEventPublisher;
import id.onyx.obdp.server.orm.dao.HostVersionDAO;
import id.onyx.obdp.server.orm.dao.RepositoryVersionDAO;
import id.onyx.obdp.server.orm.entities.HostVersionEntity;
import id.onyx.obdp.server.orm.entities.RepositoryVersionEntity;
import id.onyx.obdp.server.state.RepositoryVersionState;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@EagerSingleton
public class DistributeRepositoriesActionListener {
    private static final Logger LOG = LoggerFactory.getLogger(DistributeRepositoriesActionListener.class);
    public static final String INSTALL_PACKAGES = "install_packages";
    @Inject
    private Provider<HostVersionDAO> hostVersionDAO;
    @Inject
    private RepositoryVersionDAO repoVersionDAO;
    @Inject
    private Gson gson;

    @Inject
    public DistributeRepositoriesActionListener(OBDPEventPublisher publisher) {
        publisher.register(this);
    }

    @Subscribe
    public void onActionFinished(ActionFinalReportReceivedEvent event) {
        Long clusterId;
        if (!event.getRole().equals(INSTALL_PACKAGES)) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(event.toString());
        }
        if ((clusterId = event.getClusterId()) == null) {
            LOG.error("Distribute Repositories expected a cluster Id for host " + event.getHostname());
            return;
        }
        String repositoryVersion = null;
        RepositoryVersionState newHostState = RepositoryVersionState.INSTALL_FAILED;
        if (event.getCommandReport() == null) {
            LOG.error("Command report is null, will set all INSTALLING versions for host {} to INSTALL_FAILED.", (Object)event.getHostname());
        } else if (!event.getCommandReport().getStatus().equals(HostRoleStatus.COMPLETED.toString())) {
            LOG.warn("Distribute repositories did not complete, will set all INSTALLING versions for host {} to INSTALL_FAILED.", (Object)event.getHostname());
        } else {
            DistributeRepositoriesStructuredOutput structuredOutput = null;
            try {
                structuredOutput = (DistributeRepositoriesStructuredOutput)this.gson.fromJson(event.getCommandReport().getStructuredOut(), DistributeRepositoriesStructuredOutput.class);
            }
            catch (JsonSyntaxException e) {
                LOG.error("Cannot parse structured output %s", (Throwable)e);
            }
            if (null == structuredOutput || null == structuredOutput.repositoryVersionId) {
                LOG.error("Received an installation reponse, but it did not contain a repository version id");
            } else {
                newHostState = RepositoryVersionState.INSTALLED;
                String actualVersion = structuredOutput.actualVersion;
                RepositoryVersionEntity repoVersion = (RepositoryVersionEntity)this.repoVersionDAO.findByPK(structuredOutput.repositoryVersionId);
                if (null != repoVersion && StringUtils.isNotBlank((String)actualVersion)) {
                    if (!StringUtils.equals((String)repoVersion.getVersion(), (String)actualVersion)) {
                        repoVersion.setVersion(actualVersion);
                        repoVersion.setResolved(true);
                        this.repoVersionDAO.merge(repoVersion);
                        repositoryVersion = actualVersion;
                    } else if (!repoVersion.isResolved()) {
                        repoVersion.setResolved(true);
                        this.repoVersionDAO.merge(repoVersion);
                    }
                }
            }
        }
        List<HostVersionEntity> hostVersions = ((HostVersionDAO)this.hostVersionDAO.get()).findByHost(event.getHostname());
        for (HostVersionEntity hostVersion : hostVersions) {
            if (!event.isEmulated().booleanValue() && repositoryVersion != null && !hostVersion.getRepositoryVersion().getVersion().equals(repositoryVersion) || hostVersion.getState() != RepositoryVersionState.INSTALLING) continue;
            hostVersion.setState(newHostState);
            ((HostVersionDAO)this.hostVersionDAO.get()).merge(hostVersion);
        }
    }

    private static class DistributeRepositoriesStructuredOutput {
        @SerializedName(value="package_installation_result")
        private String packageInstallationResult;
        @SerializedName(value="actual_version")
        private String actualVersion;
        @SerializedName(value="repository_version_id")
        private Long repositoryVersionId = null;

        private DistributeRepositoriesStructuredOutput() {
        }
    }
}

