/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.events.listeners.tasks;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import id.onyx.obdp.server.EagerSingleton;
import id.onyx.obdp.server.Role;
import id.onyx.obdp.server.actionmanager.HostRoleCommand;
import id.onyx.obdp.server.actionmanager.HostRoleStatus;
import id.onyx.obdp.server.api.stomp.NamedTasksSubscriptions;
import id.onyx.obdp.server.controller.internal.CalculatedStatus;
import id.onyx.obdp.server.events.NamedTaskUpdateEvent;
import id.onyx.obdp.server.events.RequestUpdateEvent;
import id.onyx.obdp.server.events.TaskCreateEvent;
import id.onyx.obdp.server.events.TaskUpdateEvent;
import id.onyx.obdp.server.events.publishers.STOMPUpdatePublisher;
import id.onyx.obdp.server.events.publishers.TaskEventPublisher;
import id.onyx.obdp.server.orm.dao.RequestDAO;
import id.onyx.obdp.server.orm.dao.StageDAO;
import id.onyx.obdp.server.orm.entities.RequestEntity;
import id.onyx.obdp.server.orm.entities.RoleSuccessCriteriaEntity;
import id.onyx.obdp.server.orm.entities.StageEntity;
import id.onyx.obdp.server.orm.entities.StageEntityPK;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@EagerSingleton
public class TaskStatusListener {
    private static final Logger LOG = LoggerFactory.getLogger(TaskStatusListener.class);
    private Map<Long, HostRoleCommand> activeTasksMap = new ConcurrentHashMap<Long, HostRoleCommand>();
    private Map<Long, ActiveRequest> activeRequestMap = new ConcurrentHashMap<Long, ActiveRequest>();
    private Map<StageEntityPK, ActiveStage> activeStageMap = new ConcurrentHashMap<StageEntityPK, ActiveStage>();
    private StageDAO stageDAO;
    private RequestDAO requestDAO;
    private STOMPUpdatePublisher STOMPUpdatePublisher;
    private NamedTasksSubscriptions namedTasksSubscriptions;

    @Inject
    public TaskStatusListener(TaskEventPublisher taskEventPublisher, StageDAO stageDAO, RequestDAO requestDAO, STOMPUpdatePublisher STOMPUpdatePublisher2, NamedTasksSubscriptions namedTasksSubscriptions) {
        this.stageDAO = stageDAO;
        this.requestDAO = requestDAO;
        this.STOMPUpdatePublisher = STOMPUpdatePublisher2;
        this.namedTasksSubscriptions = namedTasksSubscriptions;
        taskEventPublisher.register(this);
    }

    public Map<Long, HostRoleCommand> getActiveTasksMap() {
        return this.activeTasksMap;
    }

    public Map<Long, ActiveRequest> getActiveRequestMap() {
        return this.activeRequestMap;
    }

    public Map<StageEntityPK, ActiveStage> getActiveStageMap() {
        return this.activeStageMap;
    }

    @Subscribe
    public void onTaskUpdateEvent(TaskUpdateEvent event) {
        LOG.debug("Received task update event {}", (Object)event);
        List<HostRoleCommand> hostRoleCommandListAll = event.getHostRoleCommands();
        ArrayList<HostRoleCommand> hostRoleCommandWithReceivedStatus = new ArrayList<HostRoleCommand>();
        HashSet<StageEntityPK> stagesWithReceivedTaskStatus = new HashSet<StageEntityPK>();
        HashSet<Long> requestIdsWithReceivedTaskStatus = new HashSet<Long>();
        HashSet<RequestUpdateEvent> requestsToPublish = new HashSet<RequestUpdateEvent>();
        HashSet<NamedTaskUpdateEvent> namedTasksToPublish = new HashSet<NamedTaskUpdateEvent>();
        for (HostRoleCommand hostRoleCommand : hostRoleCommandListAll) {
            Long reportedTaskId = hostRoleCommand.getTaskId();
            HostRoleCommand activeTask = this.activeTasksMap.get(reportedTaskId);
            if (activeTask == null) {
                LOG.error(String.format("Received update for a task %d which is not being tracked as running task", reportedTaskId));
                continue;
            }
            hostRoleCommandWithReceivedStatus.add(hostRoleCommand);
            StageEntityPK stageEntityPK = new StageEntityPK();
            stageEntityPK.setRequestId(hostRoleCommand.getRequestId());
            stageEntityPK.setStageId(hostRoleCommand.getStageId());
            stagesWithReceivedTaskStatus.add(stageEntityPK);
            requestIdsWithReceivedTaskStatus.add(hostRoleCommand.getRequestId());
            NamedTaskUpdateEvent namedTaskUpdateEvent = new NamedTaskUpdateEvent(hostRoleCommand);
            if (this.namedTasksSubscriptions.checkTaskId(reportedTaskId) && !namedTaskUpdateEvent.equals(new NamedTaskUpdateEvent(this.activeTasksMap.get(reportedTaskId)))) {
                namedTasksToPublish.add(namedTaskUpdateEvent);
            }
            if (hostRoleCommand.getStatus().equals((Object)HostRoleStatus.COMPLETED)) {
                this.namedTasksSubscriptions.removeTaskId(reportedTaskId);
            }
            if (this.activeTasksMap.get(reportedTaskId).getStatus().equals((Object)hostRoleCommand.getStatus())) continue;
            Long clusterId = this.activeRequestMap.get(hostRoleCommand.getRequestId()).getClusterId();
            if (clusterId != null && clusterId != -1L) {
                HashSet<RequestUpdateEvent.HostRoleCommand> hostRoleCommands = new HashSet<RequestUpdateEvent.HostRoleCommand>();
                hostRoleCommands.add(new RequestUpdateEvent.HostRoleCommand(hostRoleCommand.getTaskId(), hostRoleCommand.getRequestId(), hostRoleCommand.getStatus(), hostRoleCommand.getHostName()));
                requestsToPublish.add(new RequestUpdateEvent(hostRoleCommand.getRequestId(), this.activeRequestMap.get(hostRoleCommand.getRequestId()).getStatus(), hostRoleCommands));
                continue;
            }
            LOG.debug("No STOMP request update event was fired for host component status change due no cluster related, request id: {}, role: {}, role command: {}, host: {}, task id: {}, old state: {}, new state: {}", new Object[]{hostRoleCommand.getRequestId(), hostRoleCommand.getRole(), hostRoleCommand.getRoleCommand(), hostRoleCommand.getHostName(), hostRoleCommand.getTaskId(), this.activeTasksMap.get(reportedTaskId).getStatus(), hostRoleCommand.getStatus()});
        }
        this.updateActiveTasksMap(hostRoleCommandWithReceivedStatus);
        Boolean didAnyStageStatusUpdated = this.updateActiveStagesStatus(stagesWithReceivedTaskStatus, hostRoleCommandListAll);
        if (didAnyStageStatusUpdated.booleanValue()) {
            this.updateActiveRequestsStatus(requestIdsWithReceivedTaskStatus, stagesWithReceivedTaskStatus);
        }
        for (RequestUpdateEvent requestToPublish : requestsToPublish) {
            this.STOMPUpdatePublisher.publish(requestToPublish);
        }
        for (NamedTaskUpdateEvent namedTaskUpdateEvent : namedTasksToPublish) {
            LOG.info(String.format("NamedTaskUpdateEvent with id %s will be send", namedTaskUpdateEvent.getId()));
            this.STOMPUpdatePublisher.publish(namedTaskUpdateEvent);
        }
    }

    @Subscribe
    public void onTaskCreateEvent(TaskCreateEvent event) {
        LOG.debug("Received task create event {}", (Object)event);
        List<HostRoleCommand> hostRoleCommandListAll = event.getHostRoleCommands();
        for (HostRoleCommand hostRoleCommand : hostRoleCommandListAll) {
            this.activeTasksMap.put(hostRoleCommand.getTaskId(), hostRoleCommand);
            this.addStagePK(hostRoleCommand);
            this.addRequestId(hostRoleCommand);
        }
    }

    private void updateActiveTasksMap(List<HostRoleCommand> hostRoleCommandWithReceivedStatus) {
        for (HostRoleCommand hostRoleCommand : hostRoleCommandWithReceivedStatus) {
            Long taskId = hostRoleCommand.getTaskId();
            this.activeTasksMap.put(taskId, hostRoleCommand);
        }
    }

    private void addStagePK(HostRoleCommand hostRoleCommand) {
        StageEntityPK stageEntityPK = new StageEntityPK();
        stageEntityPK.setRequestId(hostRoleCommand.getRequestId());
        stageEntityPK.setStageId(hostRoleCommand.getStageId());
        if (this.activeStageMap.containsKey(stageEntityPK)) {
            this.activeStageMap.get(stageEntityPK).addTaskId(hostRoleCommand.getTaskId());
        } else {
            StageEntity stageEntity = this.stageDAO.findByPK(stageEntityPK);
            assert (stageEntity != null);
            HashMap<Role, Float> successFactors = new HashMap<Role, Float>();
            Collection<RoleSuccessCriteriaEntity> roleSuccessCriteriaEntities = stageEntity.getRoleSuccessCriterias();
            for (RoleSuccessCriteriaEntity successCriteriaEntity : roleSuccessCriteriaEntities) {
                successFactors.put(successCriteriaEntity.getRole(), Float.valueOf(successCriteriaEntity.getSuccessFactor().floatValue()));
            }
            HashSet taskIdSet = Sets.newHashSet((Object[])new Long[]{hostRoleCommand.getTaskId()});
            ActiveStage reportedStage = new ActiveStage(stageEntity.getStatus(), stageEntity.getDisplayStatus(), successFactors, stageEntity.isSkippable(), taskIdSet);
            this.activeStageMap.put(stageEntityPK, reportedStage);
        }
    }

    private Boolean updateActiveStagesStatus(Set<StageEntityPK> stagesWithReceivedTaskStatus, List<HostRoleCommand> hostRoleCommandListAll) {
        Boolean didAnyStageStatusUpdated = Boolean.FALSE;
        for (StageEntityPK reportedStagePK : stagesWithReceivedTaskStatus) {
            if (this.activeStageMap.containsKey(reportedStagePK)) {
                Boolean didStatusChange = this.updateStageStatus(reportedStagePK, hostRoleCommandListAll);
                if (!didStatusChange.booleanValue()) continue;
                ActiveStage reportedStage = this.activeStageMap.get(reportedStagePK);
                this.stageDAO.updateStatus(reportedStagePK, reportedStage.getStatus(), reportedStage.getDisplayStatus());
                didAnyStageStatusUpdated = Boolean.TRUE;
                continue;
            }
            LOG.error(String.format("Received update for a task whose stage is not being tracked as running stage: %s", reportedStagePK.toString()));
        }
        return didAnyStageStatusUpdated;
    }

    private void addRequestId(HostRoleCommand hostRoleCommand) {
        Long requestId = hostRoleCommand.getRequestId();
        StageEntityPK stageEntityPK = new StageEntityPK();
        stageEntityPK.setRequestId(hostRoleCommand.getRequestId());
        stageEntityPK.setStageId(hostRoleCommand.getStageId());
        if (this.activeRequestMap.containsKey(requestId)) {
            this.activeRequestMap.get(requestId).addStageEntityPK(stageEntityPK);
        } else {
            RequestEntity requestEntity = this.requestDAO.findByPK(requestId);
            assert (requestEntity != null);
            HashSet stageEntityPKs = Sets.newHashSet((Object[])new StageEntityPK[]{stageEntityPK});
            ActiveRequest request = new ActiveRequest(requestEntity.getStatus(), requestEntity.getDisplayStatus(), stageEntityPKs, requestEntity.getClusterId());
            this.activeRequestMap.put(requestId, request);
        }
    }

    private void updateActiveRequestsStatus(Set<Long> requestIdsWithReceivedTaskStatus, Set<StageEntityPK> stagesWithChangedTaskStatus) {
        for (Long reportedRequestId : requestIdsWithReceivedTaskStatus) {
            if (this.activeRequestMap.containsKey(reportedRequestId)) {
                ActiveRequest request = this.activeRequestMap.get(reportedRequestId);
                Boolean didStatusChange = this.updateRequestStatus(reportedRequestId, stagesWithChangedTaskStatus);
                if (didStatusChange.booleanValue()) {
                    this.requestDAO.updateStatus(reportedRequestId, request.getStatus(), request.getDisplayStatus());
                }
                if (!request.isCompleted().booleanValue() || !this.isAllTasksCompleted(reportedRequestId).booleanValue()) continue;
                this.removeRequestStageAndTasks(reportedRequestId);
                continue;
            }
            LOG.error(String.format("Received update for a task whose request %d is not being tracked as running request", reportedRequestId));
        }
    }

    private Boolean isAllTasksCompleted(Long requestId) {
        Boolean result = Boolean.TRUE;
        for (Map.Entry<Long, HostRoleCommand> entry : this.activeTasksMap.entrySet()) {
            if (entry.getValue().getRequestId() != requestId.longValue() || entry.getValue().getStatus().isCompletedState()) continue;
            result = Boolean.FALSE;
        }
        return result;
    }

    private void removeRequestStageAndTasks(Long requestId) {
        this.removeTasks(requestId);
        this.removeStages(requestId);
        this.removeRequest(requestId);
    }

    private List<StageEntityPK> getAllStageEntityPKForRequest(final Long requestID) {
        Predicate<StageEntityPK> predicate = new Predicate<StageEntityPK>(){

            public boolean apply(StageEntityPK stageEntityPK) {
                return stageEntityPK.getRequestId().equals(requestID);
            }
        };
        return FluentIterable.from(this.activeStageMap.keySet()).filter((Predicate)predicate).toList();
    }

    private Boolean updateStageStatus(StageEntityPK stagePK, List<HostRoleCommand> hostRoleCommandListAll) {
        Boolean didAnyStatusChanged = Boolean.FALSE;
        ActiveStage reportedStage = this.activeStageMap.get(stagePK);
        HostRoleStatus stageCurrentStatus = reportedStage.getStatus();
        HostRoleStatus stageCurrentDisplayStatus = reportedStage.getDisplayStatus();
        if (!stageCurrentDisplayStatus.isCompletedState() || !stageCurrentStatus.isCompletedState()) {
            Map<HostRoleStatus, Integer> receivedTaskStatusCount = CalculatedStatus.calculateStatusCountsForTasks(hostRoleCommandListAll, stagePK);
            HostRoleStatus statusFromPartialSet = CalculatedStatus.calculateSummaryStatusFromPartialSet(receivedTaskStatusCount, reportedStage.getSkippable());
            HostRoleStatus displayStatusFromPartialSet = CalculatedStatus.calculateSummaryStatusFromPartialSet(receivedTaskStatusCount, Boolean.FALSE);
            if (statusFromPartialSet == HostRoleStatus.PENDING || displayStatusFromPartialSet == HostRoleStatus.PENDING) {
                Function<Long, HostRoleCommand> transform = new Function<Long, HostRoleCommand>(){

                    public HostRoleCommand apply(Long taskId) {
                        return TaskStatusListener.this.activeTasksMap.get(taskId);
                    }
                };
                ImmutableList activeHostRoleCommandsOfStage = FluentIterable.from(reportedStage.getTaskIds()).transform((Function)transform).toList();
                Map<HostRoleStatus, Integer> statusCount = CalculatedStatus.calculateStatusCountsForTasks((Collection<HostRoleCommand>)activeHostRoleCommandsOfStage);
                if (displayStatusFromPartialSet == HostRoleStatus.PENDING) {
                    HostRoleStatus display_status = CalculatedStatus.calculateSummaryDisplayStatus(statusCount, activeHostRoleCommandsOfStage.size(), reportedStage.getSkippable());
                    if (display_status != stageCurrentDisplayStatus) {
                        reportedStage.setDisplayStatus(display_status);
                        didAnyStatusChanged = Boolean.TRUE;
                    }
                } else {
                    reportedStage.setDisplayStatus(displayStatusFromPartialSet);
                    didAnyStatusChanged = Boolean.TRUE;
                }
                if (statusFromPartialSet == HostRoleStatus.PENDING) {
                    HostRoleStatus status = CalculatedStatus.calculateStageStatus((List<HostRoleCommand>)activeHostRoleCommandsOfStage, statusCount, reportedStage.getSuccessFactors(), reportedStage.getSkippable());
                    if (status != stageCurrentStatus) {
                        reportedStage.setStatus(status);
                        didAnyStatusChanged = Boolean.TRUE;
                    }
                } else {
                    reportedStage.setDisplayStatus(displayStatusFromPartialSet);
                    didAnyStatusChanged = Boolean.TRUE;
                }
            } else {
                reportedStage.setStatus(statusFromPartialSet);
                reportedStage.setDisplayStatus(displayStatusFromPartialSet);
                didAnyStatusChanged = Boolean.TRUE;
            }
        }
        return didAnyStatusChanged;
    }

    private Boolean updateRequestStatus(Long requestId, Set<StageEntityPK> stagesWithChangedTaskStatus) {
        Boolean didStatusChanged = Boolean.FALSE;
        ActiveRequest request = this.activeRequestMap.get(requestId);
        HostRoleStatus requestCurrentStatus = request.getStatus();
        HostRoleStatus requestCurrentDisplayStatus = request.getDisplayStatus();
        if (!requestCurrentDisplayStatus.isCompletedState() || !requestCurrentStatus.isCompletedState()) {
            ArrayList<ActiveStage> activeStagesWithChangesTaskStatus = new ArrayList<ActiveStage>();
            for (StageEntityPK stageEntityPK : stagesWithChangedTaskStatus) {
                if (!requestId.equals(stageEntityPK.getRequestId())) continue;
                ActiveStage activeStage = this.activeStageMap.get(stageEntityPK);
                activeStagesWithChangesTaskStatus.add(activeStage);
            }
            Map<CalculatedStatus.StatusType, Map<HostRoleStatus, Integer>> stageStatusCountFromPartialSet = CalculatedStatus.calculateStatusCountsForStage(activeStagesWithChangesTaskStatus);
            HostRoleStatus statusFromPartialSet = CalculatedStatus.calculateSummaryStatusFromPartialSet(stageStatusCountFromPartialSet.get((Object)CalculatedStatus.StatusType.STATUS), Boolean.FALSE);
            HostRoleStatus displayStatusFromPartialSet = CalculatedStatus.calculateSummaryStatusFromPartialSet(stageStatusCountFromPartialSet.get((Object)CalculatedStatus.StatusType.DISPLAY_STATUS), Boolean.FALSE);
            if (statusFromPartialSet == HostRoleStatus.PENDING || displayStatusFromPartialSet == HostRoleStatus.PENDING) {
                ArrayList<ActiveStage> allActiveStages = new ArrayList<ActiveStage>();
                for (StageEntityPK stageEntityPK : request.getStageEntityPks()) {
                    ActiveStage activeStage = this.activeStageMap.get(stageEntityPK);
                    allActiveStages.add(activeStage);
                }
                Map<CalculatedStatus.StatusType, Map<HostRoleStatus, Integer>> stageStatusCount = CalculatedStatus.calculateStatusCountsForStage(allActiveStages);
                if (displayStatusFromPartialSet == HostRoleStatus.PENDING) {
                    HostRoleStatus display_status = CalculatedStatus.calculateSummaryDisplayStatus(stageStatusCount.get((Object)CalculatedStatus.StatusType.DISPLAY_STATUS), allActiveStages.size(), false);
                    if (display_status != requestCurrentDisplayStatus) {
                        request.setDisplayStatus(display_status);
                        didStatusChanged = Boolean.TRUE;
                    }
                } else {
                    request.setDisplayStatus(displayStatusFromPartialSet);
                    didStatusChanged = Boolean.TRUE;
                }
                if (statusFromPartialSet == HostRoleStatus.PENDING) {
                    HostRoleStatus status = CalculatedStatus.calculateSummaryStatus(stageStatusCount.get((Object)CalculatedStatus.StatusType.STATUS), allActiveStages.size(), false);
                    if (status != requestCurrentStatus) {
                        request.setStatus(status);
                        didStatusChanged = Boolean.TRUE;
                    }
                } else {
                    request.setDisplayStatus(displayStatusFromPartialSet);
                    didStatusChanged = Boolean.TRUE;
                }
            } else {
                request.setStatus(statusFromPartialSet);
                request.setDisplayStatus(displayStatusFromPartialSet);
                didStatusChanged = Boolean.TRUE;
            }
        }
        return didStatusChanged;
    }

    private void removeTasks(Long requestId) {
        Iterator<Map.Entry<Long, HostRoleCommand>> iter = this.activeTasksMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Long, HostRoleCommand> entry = iter.next();
            HostRoleCommand hrc = entry.getValue();
            if (hrc.getRequestId() != requestId.longValue()) continue;
            if (!hrc.getStatus().isCompletedState()) {
                LOG.error(String.format("Task %d should have been completed before being removed from running task cache(activeTasksMap)", hrc.getTaskId()));
            }
            iter.remove();
        }
    }

    private void removeStages(Long requestId) {
        List<StageEntityPK> stageEntityPKs = this.getAllStageEntityPKForRequest(requestId);
        for (StageEntityPK stageEntityPK : stageEntityPKs) {
            this.activeStageMap.remove(stageEntityPK);
        }
    }

    private void removeRequest(Long requestId) {
        this.activeRequestMap.remove(requestId);
    }

    protected class ActiveRequest {
        private HostRoleStatus status;
        private HostRoleStatus displayStatus;
        private Set<StageEntityPK> stageEntityPks;
        private Long clusterId;

        public ActiveRequest(HostRoleStatus status, HostRoleStatus displayStatus, Set<StageEntityPK> stageEntityPks, Long clusterId) {
            this.status = status;
            this.displayStatus = displayStatus;
            this.stageEntityPks = stageEntityPks;
            this.clusterId = clusterId;
        }

        public HostRoleStatus getStatus() {
            return this.status;
        }

        public void setStatus(HostRoleStatus status) {
            this.status = status;
        }

        public HostRoleStatus getDisplayStatus() {
            return this.displayStatus;
        }

        public void setDisplayStatus(HostRoleStatus displayStatus) {
            this.displayStatus = displayStatus;
        }

        public Boolean isCompleted() {
            return this.status.isCompletedState() && this.displayStatus.isCompletedState();
        }

        public Set<StageEntityPK> getStageEntityPks() {
            return this.stageEntityPks;
        }

        public void addStageEntityPK(StageEntityPK stageEntityPK) {
            this.stageEntityPks.add(stageEntityPK);
        }

        public Long getClusterId() {
            return this.clusterId;
        }

        public void setClusterId(Long clusterId) {
            this.clusterId = clusterId;
        }
    }

    public class ActiveStage {
        private HostRoleStatus status;
        private HostRoleStatus displayStatus;
        private Boolean skippable;
        private Set<Long> taskIds;
        private Map<Role, Float> successFactors = new HashMap<Role, Float>();

        public ActiveStage(HostRoleStatus status, HostRoleStatus displayStatus, Map<Role, Float> successFactors, Boolean skippable, Set<Long> taskIds) {
            this.status = status;
            this.displayStatus = displayStatus;
            this.successFactors = successFactors;
            this.skippable = skippable;
            this.taskIds = taskIds;
        }

        public HostRoleStatus getStatus() {
            return this.status;
        }

        public void setStatus(HostRoleStatus status) {
            this.status = status;
        }

        public HostRoleStatus getDisplayStatus() {
            return this.displayStatus;
        }

        public void setDisplayStatus(HostRoleStatus displayStatus) {
            this.displayStatus = displayStatus;
        }

        public Boolean getSkippable() {
            return this.skippable;
        }

        public void setSkippable(Boolean skippable) {
            this.skippable = skippable;
        }

        public Map<Role, Float> getSuccessFactors() {
            return this.successFactors;
        }

        public void setSuccessFactors(Map<Role, Float> successFactors) {
            this.successFactors = successFactors;
        }

        public Set<Long> getTaskIds() {
            return this.taskIds;
        }

        public void addTaskId(Long taskId) {
            this.taskIds.add(taskId);
        }
    }
}

