/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.events.listeners.services;

import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import id.onyx.obdp.server.EagerSingleton;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.events.HostComponentUpdate;
import id.onyx.obdp.server.events.HostComponentsUpdateEvent;
import id.onyx.obdp.server.events.MaintenanceModeEvent;
import id.onyx.obdp.server.events.ServiceUpdateEvent;
import id.onyx.obdp.server.events.publishers.OBDPEventPublisher;
import id.onyx.obdp.server.events.publishers.STOMPUpdatePublisher;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.MaintenanceState;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@Singleton
@EagerSingleton
public class ServiceUpdateListener {
    private STOMPUpdatePublisher STOMPUpdatePublisher;
    @Inject
    private Provider<Clusters> m_clusters;

    @Inject
    public ServiceUpdateListener(STOMPUpdatePublisher STOMPUpdatePublisher2, OBDPEventPublisher ambariEventPublisher) {
        STOMPUpdatePublisher2.registerAPI(this);
        ambariEventPublisher.register(this);
        this.STOMPUpdatePublisher = STOMPUpdatePublisher2;
    }

    @Subscribe
    public void onHostComponentUpdate(HostComponentsUpdateEvent event) throws OBDPException {
        Long clusterId;
        HashMap<Long, Set> clustersServices = new HashMap<Long, Set>();
        for (HostComponentUpdate hostComponentUpdate : event.getHostComponentUpdates()) {
            clusterId = hostComponentUpdate.getClusterId();
            String serviceName = hostComponentUpdate.getServiceName();
            clustersServices.computeIfAbsent(clusterId, c -> new HashSet()).add(serviceName);
        }
        for (Map.Entry entry : clustersServices.entrySet()) {
            clusterId = (Long)entry.getKey();
            String clusterName = ((Clusters)this.m_clusters.get()).getClusterById(clusterId).getClusterName();
            for (String serviceName : (Set)entry.getValue()) {
                this.STOMPUpdatePublisher.publish(new ServiceUpdateEvent(clusterName, null, serviceName, null, true));
            }
        }
    }

    @Subscribe
    public void onMaintenanceStateUpdate(MaintenanceModeEvent event) throws OBDPException {
        if (event.getService() == null) {
            return;
        }
        Long clusterId = event.getClusterId();
        String clusterName = ((Clusters)this.m_clusters.get()).getClusterById(clusterId).getClusterName();
        String serviceName = event.getService().getName();
        MaintenanceState maintenanceState = event.getMaintenanceState();
        this.STOMPUpdatePublisher.publish(new ServiceUpdateEvent(clusterName, maintenanceState, serviceName, null, false));
    }
}

