/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.events.listeners.requests;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Injector;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.events.DefaultMessageEmitter;
import id.onyx.obdp.server.events.STOMPEvent;
import id.onyx.obdp.server.events.publishers.STOMPUpdatePublisher;
import java.util.Collections;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;

public class STOMPUpdateListener {
    @Autowired
    private DefaultMessageEmitter defaultMessageEmitter;
    private final Set<STOMPEvent.Type> typesToProcess;

    public STOMPUpdateListener(Injector injector, Set<STOMPEvent.Type> typesToProcess) {
        STOMPUpdatePublisher STOMPUpdatePublisher2 = (STOMPUpdatePublisher)injector.getInstance(STOMPUpdatePublisher.class);
        STOMPUpdatePublisher2.registerAgent(this);
        STOMPUpdatePublisher2.registerAPI(this);
        this.typesToProcess = typesToProcess == null ? Collections.emptySet() : typesToProcess;
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onUpdateEvent(STOMPEvent event) throws OBDPException, InterruptedException {
        if (this.typesToProcess.contains((Object)event.getType())) {
            this.defaultMessageEmitter.emitMessage(event);
        }
    }
}

