/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.events.listeners.hosts;

import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import id.onyx.obdp.server.EagerSingleton;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.api.services.stackadvisor.StackAdvisorHelper;
import id.onyx.obdp.server.events.AlertEvent;
import id.onyx.obdp.server.events.AlertStateChangeEvent;
import id.onyx.obdp.server.events.HostStateUpdateEvent;
import id.onyx.obdp.server.events.HostStatusUpdateEvent;
import id.onyx.obdp.server.events.HostUpdateEvent;
import id.onyx.obdp.server.events.InitialAlertEvent;
import id.onyx.obdp.server.events.MaintenanceModeEvent;
import id.onyx.obdp.server.events.publishers.AlertEventPublisher;
import id.onyx.obdp.server.events.publishers.OBDPEventPublisher;
import id.onyx.obdp.server.events.publishers.STOMPUpdatePublisher;
import id.onyx.obdp.server.orm.dao.AlertSummaryDTO;
import id.onyx.obdp.server.orm.dao.AlertsDAO;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.Host;
import id.onyx.obdp.server.state.MaintenanceState;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

@Singleton
@EagerSingleton
public class HostUpdateListener {
    private Map<Long, Map<String, HostUpdateEvent>> hosts = new HashMap<Long, Map<String, HostUpdateEvent>>();
    @Inject
    private STOMPUpdatePublisher STOMPUpdatePublisher;
    @Inject
    private AlertsDAO alertsDAO;
    @Inject
    private Provider<Clusters> m_clusters;
    @Inject
    private Provider<StackAdvisorHelper> stackAdvisorHelperProvider;

    @Inject
    public HostUpdateListener(OBDPEventPublisher ambariEventPublisher, AlertEventPublisher m_alertEventPublisher) {
        ambariEventPublisher.register(this);
        m_alertEventPublisher.register(this);
    }

    @Subscribe
    public void onHostStatusUpdate(HostStatusUpdateEvent event) throws OBDPException {
        String hostName = event.getHostName();
        Long lastHeartbeatTime = ((Clusters)this.m_clusters.get()).getHost(hostName).getLastHeartbeatTime();
        for (Cluster cluster : ((Clusters)this.m_clusters.get()).getClustersForHost(hostName)) {
            Long clusterId = cluster.getClusterId();
            HostUpdateEvent hostUpdateEvent = this.retrieveHostUpdateFromCache(clusterId, hostName);
            if (hostUpdateEvent.getHostStatus().equals(event.getHostStatus())) continue;
            hostUpdateEvent.setHostStatus(event.getHostStatus());
            hostUpdateEvent.setLastHeartbeatTime(lastHeartbeatTime);
            this.STOMPUpdatePublisher.publish(HostUpdateEvent.createHostStatusUpdate(hostUpdateEvent.getClusterName(), hostUpdateEvent.getHostName(), hostUpdateEvent.getHostStatus(), hostUpdateEvent.getLastHeartbeatTime()));
            ((StackAdvisorHelper)this.stackAdvisorHelperProvider.get()).clearCaches(hostName);
        }
    }

    @Subscribe
    public void onHostStateUpdate(HostStateUpdateEvent event) throws OBDPException {
        String hostName = event.getHostName();
        Long lastHeartbeatTime = ((Clusters)this.m_clusters.get()).getHost(hostName).getLastHeartbeatTime();
        for (Cluster cluster : ((Clusters)this.m_clusters.get()).getClustersForHost(hostName)) {
            Long clusterId = cluster.getClusterId();
            HostUpdateEvent hostUpdateEvent = this.retrieveHostUpdateFromCache(clusterId, hostName);
            if (hostUpdateEvent.getHostState().equals((Object)event.getHostState())) continue;
            hostUpdateEvent.setHostState(event.getHostState());
            hostUpdateEvent.setLastHeartbeatTime(lastHeartbeatTime);
            this.STOMPUpdatePublisher.publish(HostUpdateEvent.createHostStateUpdate(hostUpdateEvent.getClusterName(), hostUpdateEvent.getHostName(), hostUpdateEvent.getHostState(), hostUpdateEvent.getLastHeartbeatTime()));
        }
        ((StackAdvisorHelper)this.stackAdvisorHelperProvider.get()).clearCaches(hostName);
    }

    @Subscribe
    public void onAlertsHostUpdate(AlertEvent event) throws OBDPException {
        if (!(event instanceof AlertStateChangeEvent) && !(event instanceof InitialAlertEvent)) {
            return;
        }
        String hostName = event instanceof AlertStateChangeEvent ? ((AlertStateChangeEvent)event).getNewHistoricalEntry().getHostName() : ((InitialAlertEvent)event).getNewHistoricalEntry().getHostName();
        if (StringUtils.isEmpty((String)hostName)) {
            return;
        }
        Long clusterId = event.getClusterId();
        HostUpdateEvent hostUpdateEvent = this.retrieveHostUpdateFromCache(clusterId, hostName);
        AlertSummaryDTO summary = this.alertsDAO.findCurrentCounts(clusterId, null, hostName);
        if (hostUpdateEvent.getAlertsSummary().equals(summary)) {
            return;
        }
        hostUpdateEvent.setAlertsSummary(summary);
        this.STOMPUpdatePublisher.publish(HostUpdateEvent.createHostAlertsUpdate(hostUpdateEvent.getClusterName(), hostName, summary));
    }

    @Subscribe
    public void onMaintenanceStateUpdate(MaintenanceModeEvent event) throws OBDPException {
        Long clusterId = event.getClusterId();
        if (event.getHost() != null || event.getServiceComponentHost() != null) {
            String hostName = event.getHost() == null ? event.getServiceComponentHost().getHostName() : event.getHost().getHostName();
            HostUpdateEvent hostUpdateEvent = this.retrieveHostUpdateFromCache(clusterId, hostName);
            AlertSummaryDTO summary = this.alertsDAO.findCurrentCounts(clusterId, null, hostName);
            if (hostUpdateEvent.getAlertsSummary().equals(summary)) {
                return;
            }
            hostUpdateEvent.setAlertsSummary(summary);
            if (event.getHost() != null) {
                MaintenanceState maintenanceState = event.getMaintenanceState();
                hostUpdateEvent.setMaintenanceState(maintenanceState);
                this.STOMPUpdatePublisher.publish(HostUpdateEvent.createHostMaintenanceStatusUpdate(hostUpdateEvent.getClusterName(), hostName, maintenanceState, summary));
            } else {
                this.STOMPUpdatePublisher.publish(HostUpdateEvent.createHostAlertsUpdate(hostUpdateEvent.getClusterName(), hostName, summary));
            }
            ((StackAdvisorHelper)this.stackAdvisorHelperProvider.get()).clearCaches(hostName);
        } else if (event.getService() != null) {
            String serviceName = event.getService().getName();
            for (String hostName : ((Clusters)this.m_clusters.get()).getCluster(clusterId).getService(serviceName).getServiceHosts()) {
                HostUpdateEvent hostUpdateEvent = this.retrieveHostUpdateFromCache(clusterId, hostName);
                AlertSummaryDTO summary = this.alertsDAO.findCurrentCounts(clusterId, null, hostName);
                if (hostUpdateEvent.getAlertsSummary().equals(summary)) continue;
                hostUpdateEvent.setAlertsSummary(summary);
                this.STOMPUpdatePublisher.publish(HostUpdateEvent.createHostAlertsUpdate(hostUpdateEvent.getClusterName(), hostName, summary));
                ((StackAdvisorHelper)this.stackAdvisorHelperProvider.get()).clearCaches(hostName);
            }
        }
    }

    private HostUpdateEvent retrieveHostUpdateFromCache(Long clusterId, String hostName) throws OBDPException {
        HostUpdateEvent hostUpdateEvent;
        if (this.hosts.containsKey(clusterId) && this.hosts.get(clusterId).containsKey(hostName)) {
            hostUpdateEvent = this.hosts.get(clusterId).get(hostName);
        } else {
            hostUpdateEvent = this.createHostUpdateEvent(clusterId, hostName);
            if (!this.hosts.containsKey(clusterId)) {
                this.hosts.put(clusterId, new HashMap());
            }
            this.hosts.get(clusterId).put(hostName, hostUpdateEvent);
        }
        return hostUpdateEvent;
    }

    private HostUpdateEvent createHostUpdateEvent(Long clusterId, String hostName) throws OBDPException {
        String clusterName = ((Clusters)this.m_clusters.get()).getClusterById(clusterId).getClusterName();
        Host host = ((Clusters)this.m_clusters.get()).getHost(hostName);
        AlertSummaryDTO summary = this.alertsDAO.findCurrentCounts(clusterId, null, hostName);
        return new HostUpdateEvent(clusterName, hostName, host.getStatus(), host.getState(), host.getLastHeartbeatTime(), host.getMaintenanceState(clusterId), summary);
    }
}

