/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.events.listeners.hostcomponents;

import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import id.onyx.obdp.server.EagerSingleton;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.events.HostComponentUpdate;
import id.onyx.obdp.server.events.HostComponentsUpdateEvent;
import id.onyx.obdp.server.events.MaintenanceModeEvent;
import id.onyx.obdp.server.events.StaleConfigsUpdateEvent;
import id.onyx.obdp.server.events.publishers.OBDPEventPublisher;
import id.onyx.obdp.server.events.publishers.STOMPUpdatePublisher;
import id.onyx.obdp.server.state.ConfigHelper;
import id.onyx.obdp.server.state.MaintenanceState;
import id.onyx.obdp.server.state.ServiceComponentHost;
import id.onyx.obdp.server.state.svccomphost.ServiceComponentHostImpl;
import java.util.Collections;

@Singleton
@EagerSingleton
public class HostComponentsUpdateListener {
    private final STOMPUpdatePublisher STOMPUpdatePublisher;
    @Inject
    private Provider<ConfigHelper> m_configHelper;

    @Inject
    public HostComponentsUpdateListener(OBDPEventPublisher ambariEventPublisher, STOMPUpdatePublisher STOMPUpdatePublisher2) {
        ambariEventPublisher.register(this);
        this.STOMPUpdatePublisher = STOMPUpdatePublisher2;
    }

    @Subscribe
    public void onMaintenanceStateUpdate(MaintenanceModeEvent event) {
        if (event.getServiceComponentHost() != null) {
            Long clusterId = event.getClusterId();
            ServiceComponentHost serviceComponentHost = event.getServiceComponentHost();
            String serviceName = serviceComponentHost.getServiceName();
            String componentName = serviceComponentHost.getServiceComponentName();
            String hostName = serviceComponentHost.getHostName();
            MaintenanceState maintenanceState = serviceComponentHost.getMaintenanceState();
            HostComponentUpdate hostComponentUpdate = HostComponentUpdate.createHostComponentMaintenanceStatusUpdate(clusterId, serviceName, hostName, componentName, maintenanceState);
            HostComponentsUpdateEvent hostComponentsUpdateEvent = new HostComponentsUpdateEvent(Collections.singletonList(hostComponentUpdate));
            this.STOMPUpdatePublisher.publish(hostComponentsUpdateEvent);
        }
    }

    @Subscribe
    public void onStaleConfigsStateUpdate(StaleConfigsUpdateEvent staleConfigsUpdateEvent) throws OBDPException {
        ServiceComponentHostImpl serviceComponentHost = staleConfigsUpdateEvent.getServiceComponentHost();
        if (staleConfigsUpdateEvent.getStaleConfigs() != null) {
            boolean staleConfigs = staleConfigsUpdateEvent.getStaleConfigs();
            if (((ConfigHelper)this.m_configHelper.get()).wasStaleConfigsStatusUpdated(serviceComponentHost.getClusterId(), serviceComponentHost.getHost().getHostId(), serviceComponentHost.getServiceName(), serviceComponentHost.getServiceComponentName(), staleConfigs)) {
                this.STOMPUpdatePublisher.publish(new HostComponentsUpdateEvent(Collections.singletonList(HostComponentUpdate.createHostComponentStaleConfigsStatusUpdate(serviceComponentHost.getClusterId(), serviceComponentHost.getServiceName(), serviceComponentHost.getHostName(), serviceComponentHost.getServiceComponentName(), staleConfigs))));
            }
        }
    }
}

