/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.events.listeners.alerts;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import id.onyx.obdp.server.EagerSingleton;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.controller.RootService;
import id.onyx.obdp.server.events.AlertStateChangeEvent;
import id.onyx.obdp.server.events.publishers.AlertEventPublisher;
import id.onyx.obdp.server.orm.dao.AlertDispatchDAO;
import id.onyx.obdp.server.orm.entities.AlertCurrentEntity;
import id.onyx.obdp.server.orm.entities.AlertDefinitionEntity;
import id.onyx.obdp.server.orm.entities.AlertGroupEntity;
import id.onyx.obdp.server.orm.entities.AlertHistoryEntity;
import id.onyx.obdp.server.orm.entities.AlertNoticeEntity;
import id.onyx.obdp.server.orm.entities.AlertTargetEntity;
import id.onyx.obdp.server.state.Alert;
import id.onyx.obdp.server.state.AlertFirmness;
import id.onyx.obdp.server.state.AlertState;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.MaintenanceState;
import id.onyx.obdp.server.state.NotificationState;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@EagerSingleton
public class AlertStateChangedListener {
    private static final Logger LOG = LoggerFactory.getLogger(AlertStateChangedListener.class);
    private static final Logger ALERT_LOG = LoggerFactory.getLogger((String)"alerts");
    private static final String ALERT_LOG_MESSAGE = "[{}] [{}] [{}] [{}] ({}) {}";
    @Inject
    private AlertDispatchDAO m_alertsDispatchDao;
    @Inject
    private Provider<Clusters> m_clusters;

    @Inject
    public AlertStateChangedListener(AlertEventPublisher publisher) {
        publisher.register(this);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onAlertEvent(AlertStateChangeEvent event) {
        LOG.debug("Received event {}", (Object)event);
        Alert alert = event.getAlert();
        AlertCurrentEntity current = event.getCurrentAlert();
        AlertHistoryEntity history = event.getNewHistoricalEntry();
        AlertDefinitionEntity definition = history.getAlertDefinition();
        ALERT_LOG.info(ALERT_LOG_MESSAGE, new Object[]{alert.getState(), current.getFirmness(), definition.getServiceName(), definition.getDefinitionName(), definition.getLabel(), alert.getText()});
        if (current.getFirmness() == AlertFirmness.SOFT) {
            return;
        }
        if (history.getAlertState() == AlertState.OK && event.getFromFirmness() == AlertFirmness.SOFT) {
            return;
        }
        AlertCurrentEntity currentAlert = event.getCurrentAlert();
        if (null != currentAlert && currentAlert.getMaintenanceState() != MaintenanceState.OFF) {
            return;
        }
        List<AlertGroupEntity> groups = this.m_alertsDispatchDao.findGroupsByDefinition(definition);
        LinkedList<AlertNoticeEntity> notices = new LinkedList<AlertNoticeEntity>();
        for (AlertGroupEntity group : groups) {
            Set<AlertTargetEntity> targets = group.getAlertTargets();
            if (null == targets || targets.size() == 0) continue;
            for (AlertTargetEntity target : targets) {
                if (!this.canDispatch(target, history, definition)) continue;
                AlertNoticeEntity notice = new AlertNoticeEntity();
                notice.setUuid(UUID.randomUUID().toString());
                notice.setAlertTarget(target);
                notice.setAlertHistory(event.getNewHistoricalEntry());
                notice.setNotifyState(NotificationState.PENDING);
                notices.add(notice);
            }
        }
        if (!notices.isEmpty()) {
            this.m_alertsDispatchDao.createNotices(notices);
        }
    }

    private boolean canDispatch(AlertTargetEntity target, AlertHistoryEntity history, AlertDefinitionEntity definition) {
        if (!target.isEnabled()) {
            return false;
        }
        Set<AlertState> alertStates = target.getAlertStates();
        if (null != alertStates && alertStates.size() > 0 && !alertStates.contains((Object)history.getAlertState())) {
            return false;
        }
        Long clusterId = history.getClusterId();
        try {
            String serviceName;
            Cluster cluster = ((Clusters)this.m_clusters.get()).getClusterById(clusterId);
            if (null != cluster.getUpgradeInProgress() && !StringUtils.equals((String)(serviceName = definition.getServiceName()), (String)RootService.OBDP.name())) {
                LOG.debug("Skipping alert notifications for {} because the cluster is upgrading", (Object)definition.getDefinitionName(), (Object)target);
                return false;
            }
        }
        catch (OBDPException ambariException) {
            LOG.warn("Unable to process an alert state change for cluster with ID {} because it does not exist", (Object)clusterId);
            return false;
        }
        return true;
    }
}

