/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.events.listeners.alerts;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.google.common.util.concurrent.Striped;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import id.onyx.obdp.server.EagerSingleton;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.events.ServiceInstalledEvent;
import id.onyx.obdp.server.events.ServiceRemovedEvent;
import id.onyx.obdp.server.events.publishers.OBDPEventPublisher;
import id.onyx.obdp.server.orm.dao.AlertDefinitionDAO;
import id.onyx.obdp.server.orm.dao.AlertDispatchDAO;
import id.onyx.obdp.server.orm.entities.AlertDefinitionEntity;
import id.onyx.obdp.server.orm.entities.AlertGroupEntity;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.alert.AlertDefinition;
import id.onyx.obdp.server.state.alert.AlertDefinitionFactory;
import java.text.MessageFormat;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@EagerSingleton
public class AlertServiceStateListener {
    private static final Logger LOG = LoggerFactory.getLogger(AlertServiceStateListener.class);
    @Inject
    private Provider<OBDPMetaInfo> m_metaInfoProvider;
    @Inject
    private AlertDefinitionFactory m_alertDefinitionFactory;
    @Inject
    private AlertDispatchDAO m_alertDispatchDao;
    @Inject
    private AlertDefinitionDAO m_definitionDao;
    @Inject
    private Provider<Clusters> m_clusters;
    private Striped<Lock> m_locksByService = Striped.lazyWeakLock((int)20);

    @Inject
    public AlertServiceStateListener(OBDPEventPublisher publisher) {
        publisher.register(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Subscribe
    @AllowConcurrentEvents
    public void onAmbariEvent(ServiceInstalledEvent event) {
        LOG.debug("Received event {}", (Object)event);
        long clusterId = event.getClusterId();
        String stackName = event.getStackName();
        String stackVersion = event.getStackVersion();
        String serviceName = event.getServiceName();
        Lock lock = (Lock)this.m_locksByService.get((Object)serviceName);
        lock.lock();
        try {
            if (null == this.m_alertDispatchDao.findDefaultServiceGroup(clusterId, serviceName)) {
                try {
                    this.m_alertDispatchDao.createDefaultGroup(clusterId, serviceName);
                }
                catch (OBDPException ambariException) {
                    LOG.error("Unable to create a default alert group for {}", (Object)event.getServiceName(), (Object)ambariException);
                }
            }
            try {
                Set<AlertDefinition> alertDefinitions = ((OBDPMetaInfo)this.m_metaInfoProvider.get()).getAlertDefinitions(stackName, stackVersion, serviceName);
                for (AlertDefinition definition : alertDefinitions) {
                    AlertDefinitionEntity entity = this.m_alertDefinitionFactory.coerce(clusterId, definition);
                    this.m_definitionDao.create(entity);
                }
            }
            catch (OBDPException ae) {
                String message = MessageFormat.format("Unable to populate alert definitions from the database during installation of {0}", serviceName);
                LOG.error(message, (Throwable)ae);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Subscribe
    @AllowConcurrentEvents
    public void onAmbariEvent(ServiceRemovedEvent event) {
        LOG.debug("Received event {}", (Object)event);
        try {
            ((Clusters)this.m_clusters.get()).getClusterById(event.getClusterId());
        }
        catch (OBDPException e) {
            LOG.warn("Unable to retrieve cluster with id {}", (Object)event.getClusterId());
            return;
        }
        String serviceName = event.getServiceName();
        Lock lock = (Lock)this.m_locksByService.get((Object)serviceName);
        lock.lock();
        try {
            List<AlertDefinitionEntity> definitions = this.m_definitionDao.findByService(event.getClusterId(), event.getServiceName());
            for (AlertDefinitionEntity definition : definitions) {
                try {
                    this.m_definitionDao.remove(definition);
                }
                catch (Exception exception) {
                    LOG.error("Unable to remove alert definition {}", (Object)definition.getDefinitionName(), (Object)exception);
                }
            }
            AlertGroupEntity group = this.m_alertDispatchDao.findGroupByName(event.getClusterId(), event.getServiceName());
            if (null != group && group.isDefault()) {
                try {
                    this.m_alertDispatchDao.remove(group);
                }
                catch (Exception exception) {
                    LOG.error("Unable to remove default alert group {}", (Object)group.getGroupName(), (Object)exception);
                }
            }
        }
        finally {
            lock.unlock();
        }
    }
}

