/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.events.listeners.alerts;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import id.onyx.obdp.server.EagerSingleton;
import id.onyx.obdp.server.events.ServiceComponentUninstalledEvent;
import id.onyx.obdp.server.events.publishers.OBDPEventPublisher;
import id.onyx.obdp.server.orm.dao.AlertsDAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EagerSingleton
public class AlertServiceComponentHostListener {
    private static final Logger LOG = LoggerFactory.getLogger(AlertServiceComponentHostListener.class);
    @Inject
    private AlertsDAO m_alertsDao = null;

    @Inject
    public AlertServiceComponentHostListener(OBDPEventPublisher publisher) {
        publisher.register(this);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onEvent(ServiceComponentUninstalledEvent event) {
        LOG.debug("Received event {}", (Object)event);
        long clusterId = event.getClusterId();
        String serviceName = event.getServiceName();
        String componentName = event.getComponentName();
        String hostName = event.getHostName();
        this.m_alertsDao.removeCurrentByServiceComponentHost(clusterId, serviceName, componentName, hostName);
    }
}

