/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.events.listeners.alerts;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.google.common.util.concurrent.Striped;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import id.onyx.obdp.server.EagerSingleton;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.api.query.render.AlertSummaryGroupedRenderer;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.controller.MaintenanceStateHelper;
import id.onyx.obdp.server.controller.RootComponent;
import id.onyx.obdp.server.controller.RootService;
import id.onyx.obdp.server.events.AlertEvent;
import id.onyx.obdp.server.events.AlertReceivedEvent;
import id.onyx.obdp.server.events.AlertStateChangeEvent;
import id.onyx.obdp.server.events.AlertUpdateEvent;
import id.onyx.obdp.server.events.InitialAlertEvent;
import id.onyx.obdp.server.events.publishers.AlertEventPublisher;
import id.onyx.obdp.server.events.publishers.STOMPUpdatePublisher;
import id.onyx.obdp.server.orm.RequiresSession;
import id.onyx.obdp.server.orm.dao.AlertDefinitionDAO;
import id.onyx.obdp.server.orm.dao.AlertsDAO;
import id.onyx.obdp.server.orm.entities.AlertCurrentEntity;
import id.onyx.obdp.server.orm.entities.AlertDefinitionEntity;
import id.onyx.obdp.server.orm.entities.AlertHistoryEntity;
import id.onyx.obdp.server.state.Alert;
import id.onyx.obdp.server.state.AlertFirmness;
import id.onyx.obdp.server.state.AlertState;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.Host;
import id.onyx.obdp.server.state.MaintenanceState;
import id.onyx.obdp.server.state.alert.AlertHelper;
import id.onyx.obdp.server.state.alert.SourceType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.eclipse.jetty.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@EagerSingleton
public class AlertReceivedListener {
    private static final Logger LOG = LoggerFactory.getLogger(AlertReceivedListener.class);
    @Inject
    Configuration m_configuration;
    @Inject
    AlertsDAO m_alertsDao;
    @Inject
    AlertDefinitionDAO m_definitionDao;
    @Inject
    private Provider<Clusters> m_clusters;
    @Inject
    private STOMPUpdatePublisher STOMPUpdatePublisher;
    @Inject
    private Provider<MaintenanceStateHelper> m_maintenanceStateHelper;
    @Inject
    private AlertHelper alertHelper;
    private AlertEventPublisher m_alertEventPublisher;
    private Striped<Lock> creationLocks = Striped.lazyWeakLock((int)100);

    @Inject
    public AlertReceivedListener(AlertEventPublisher publisher) {
        this.m_alertEventPublisher = publisher;
        this.m_alertEventPublisher.register(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Subscribe
    @AllowConcurrentEvents
    @RequiresSession
    public void onAlertEvent(AlertReceivedEvent event) throws OBDPException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(event.toString());
        }
        List<Alert> alerts = event.getAlerts();
        ArrayList<AlertCurrentEntity> toMerge = new ArrayList<AlertCurrentEntity>();
        ArrayList<AlertCurrentEntity> toCreateHistoryAndMerge = new ArrayList<AlertCurrentEntity>();
        ArrayList<AlertEvent> alertEvents = new ArrayList<AlertEvent>(20);
        HashMap<Long, Map<String, AlertSummaryGroupedRenderer.AlertDefinitionSummary>> alertUpdates = new HashMap<Long, Map<String, AlertSummaryGroupedRenderer.AlertDefinitionSummary>>();
        for (Alert alert : alerts) {
            AlertDefinitionEntity definition;
            Long clusterId = alert.getClusterId();
            if (clusterId == null) {
                clusterId = event.getClusterId();
            }
            if (null == (definition = this.m_definitionDao.findByName(clusterId, alert.getName()))) {
                LOG.warn("Received an alert for {} which is a definition that does not exist in cluster id={}", (Object)alert.getName(), (Object)clusterId);
                continue;
            }
            alert.setComponent(definition.getComponentName());
            alert.setLabel(definition.getComponentName());
            alert.setService(definition.getServiceName());
            if (!this.isValid(alert)) continue;
            if (!definition.getEnabled()) {
                LOG.debug("Received an alert for {} which is disabled. No more alerts should be received for this definition.", (Object)alert.getName());
                continue;
            }
            this.updateAlertDetails(alert, definition);
            if (!this.isValid(alert)) continue;
            AlertState alertState = alert.getState();
            AlertCurrentEntity current = this.getCurrentEntity(clusterId, alert, definition);
            if (null == current) {
                if (alertState == AlertState.SKIPPED) continue;
                int key = Objects.hash(clusterId, alert.getName(), alert.getHostName());
                Lock lock = (Lock)this.creationLocks.get((Object)key);
                lock.lock();
                try {
                    current = this.getCurrentEntity(clusterId, alert, definition);
                    if (null != current) continue;
                    AlertHistoryEntity history = this.createHistory(clusterId, definition, alert);
                    MaintenanceState maintenanceState = this.getMaintenanceState(alert, clusterId);
                    current = new AlertCurrentEntity();
                    current.setMaintenanceState(maintenanceState);
                    current.setAlertHistory(history);
                    current.setLatestTimestamp(alert.getTimestamp());
                    current.setOriginalTimestamp(alert.getTimestamp());
                    this.clearStaleAlerts(alert.getHostName(), definition.getDefinitionId());
                    current.setFirmness(AlertFirmness.HARD);
                    this.m_alertsDao.create(current);
                    alertEvents.add(new InitialAlertEvent(clusterId, alert, current));
                    if (!alertUpdates.containsKey(clusterId)) {
                        alertUpdates.put(clusterId, new HashMap());
                    }
                    Map summaries = (Map)alertUpdates.get(clusterId);
                    AlertSummaryGroupedRenderer.updateSummary(summaries, definition.getDefinitionId(), definition.getDefinitionName(), alertState, alert.getTimestamp(), maintenanceState, alert.getText());
                    continue;
                }
                finally {
                    lock.unlock();
                    continue;
                }
            }
            if (alertState == current.getAlertHistory().getAlertState() || alertState == AlertState.SKIPPED) {
                String alertText;
                current.setLatestTimestamp(alert.getTimestamp());
                this.clearStaleAlerts(alert.getHostName(), definition.getDefinitionId());
                if (alertState != AlertState.SKIPPED) {
                    current.setLatestText(alert.getText());
                    long occurrences = current.getOccurrences() + 1L;
                    current.setOccurrences(occurrences);
                    AlertFirmness firmness = current.getFirmness();
                    int repeatTolerance = this.getRepeatTolerance(definition, clusterId);
                    if (firmness == AlertFirmness.SOFT && occurrences >= (long)repeatTolerance) {
                        current.setFirmness(AlertFirmness.HARD);
                        AlertStateChangeEvent stateChangedEvent = new AlertStateChangeEvent(clusterId, alert, current, alertState, firmness);
                        alertEvents.add(stateChangedEvent);
                    }
                }
                if (alertState == AlertState.SKIPPED && StringUtils.isNotBlank((String)(alertText = alert.getText()))) {
                    current.setLatestText(alertText);
                }
                toMerge.add(current);
                continue;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Alert State Changed: CurrentId {}, CurrentTimestamp {}, HistoryId {}, HistoryState {}", new Object[]{current.getAlertId(), current.getLatestTimestamp(), current.getAlertHistory().getAlertId(), current.getAlertHistory().getAlertState()});
            }
            AlertHistoryEntity oldHistory = current.getAlertHistory();
            AlertState oldState = oldHistory.getAlertState();
            AlertFirmness oldFirmness = current.getFirmness();
            AlertHistoryEntity history = this.createHistory(clusterId, oldHistory.getAlertDefinition(), alert);
            current.setLatestTimestamp(alert.getTimestamp());
            current.setOriginalTimestamp(alert.getTimestamp());
            current.setLatestText(alert.getText());
            this.clearStaleAlerts(alert.getHostName(), definition.getDefinitionId());
            current.setAlertHistory(history);
            switch (alertState) {
                case OK: {
                    current.setOccurrences(1L);
                    break;
                }
                case CRITICAL: 
                case SKIPPED: 
                case UNKNOWN: 
                case WARNING: {
                    if (oldState == AlertState.OK) {
                        current.setOccurrences(1L);
                        break;
                    }
                    current.setOccurrences(current.getOccurrences() + 1L);
                    break;
                }
            }
            AlertFirmness firmness = this.calculateFirmnessForStateChange(clusterId, definition, alertState, current.getOccurrences());
            current.setFirmness(firmness);
            toCreateHistoryAndMerge.add(current);
            alertEvents.add(new AlertStateChangeEvent(clusterId, alert, current, oldState, oldFirmness));
            MaintenanceState maintenanceState = this.getMaintenanceState(alert, clusterId);
            if (!alertUpdates.containsKey(clusterId)) {
                alertUpdates.put(clusterId, new HashMap());
            }
            Map summaries = (Map)alertUpdates.get(clusterId);
            AlertSummaryGroupedRenderer.updateSummary(summaries, definition.getDefinitionId(), definition.getDefinitionName(), alertState, alert.getTimestamp(), maintenanceState, alert.getText());
        }
        this.m_alertsDao.saveEntities(toMerge, toCreateHistoryAndMerge);
        for (AlertEvent eventToFire : alertEvents) {
            this.m_alertEventPublisher.publish(eventToFire);
        }
        if (!alertUpdates.isEmpty()) {
            this.STOMPUpdatePublisher.publish(new AlertUpdateEvent(alertUpdates));
        }
    }

    private void clearStaleAlerts(String hostName, Long definitionId) throws OBDPException {
        if (StringUtil.isNotBlank((String)hostName)) {
            Host host = ((Clusters)this.m_clusters.get()).getHosts().stream().filter(h -> h.getHostName().equals(hostName)).findFirst().orElse(null);
            if (host != null) {
                this.alertHelper.clearStaleAlert(host.getHostId(), definitionId);
            }
        } else {
            this.alertHelper.clearStaleAlert(definitionId);
        }
    }

    private void updateAlertDetails(Alert alert, AlertDefinitionEntity definition) {
        if (alert.getService() == null) {
            alert.setService(definition.getServiceName());
        }
        if (alert.getComponent() == null) {
            alert.setComponent(definition.getComponentName());
        }
    }

    private MaintenanceState getMaintenanceState(Alert alert, Long clusterId) {
        MaintenanceState maintenanceState = MaintenanceState.OFF;
        try {
            maintenanceState = ((MaintenanceStateHelper)this.m_maintenanceStateHelper.get()).getEffectiveState(clusterId, alert);
        }
        catch (Exception exception) {
            LOG.error("Unable to determine the maintenance mode state for {}, defaulting to OFF", (Object)alert, (Object)exception);
        }
        return maintenanceState;
    }

    private AlertCurrentEntity getCurrentEntity(long clusterId, Alert alert, AlertDefinitionEntity definition) {
        if (StringUtils.isBlank((String)alert.getHostName()) || definition.isHostIgnored()) {
            return this.m_alertsDao.findCurrentByNameNoHost(clusterId, alert.getName());
        }
        return this.m_alertsDao.findCurrentByHostAndName(clusterId, alert.getHostName(), alert.getName());
    }

    private boolean isValid(Alert alert) {
        Cluster cluster;
        Long clusterId = alert.getClusterId();
        String serviceName = alert.getService();
        String componentName = alert.getComponent();
        String hostName = alert.getHostName();
        String ambariServiceName = RootService.OBDP.name();
        String ambariServerComponentName = RootComponent.OBDP_SERVER.name();
        String ambariAgentComponentName = RootComponent.AMBARI_AGENT.name();
        if (ambariServiceName.equals(serviceName) && ambariServerComponentName.equals(componentName)) {
            return true;
        }
        Clusters clusters = (Clusters)this.m_clusters.get();
        if (clusterId == null) {
            if (StringUtils.isBlank((String)hostName)) {
                return true;
            }
            if (!clusters.hostExists(hostName)) {
                LOG.error("Unable to process alert {} for an invalid host named {}", (Object)alert.getName(), (Object)hostName);
                return false;
            }
            return true;
        }
        try {
            cluster = clusters.getCluster(clusterId);
            if (null == cluster) {
                LOG.error("Unable to process alert {} for cluster id={}", (Object)alert.getName(), (Object)clusterId);
                return false;
            }
        }
        catch (OBDPException ambariException) {
            String msg = String.format("Unable to process alert %s for cluster id=%s", alert.getName(), clusterId);
            LOG.error(msg, (Throwable)ambariException);
            return false;
        }
        if (ambariServiceName.equals(serviceName) && ambariAgentComponentName.equals(componentName)) {
            if (StringUtils.isBlank((String)hostName) || !clusters.hostExists(hostName) || !clusters.isHostMappedToCluster(clusterId, hostName)) {
                LOG.warn("Unable to process alert {} for cluster {} and host {} because the host is not a part of the cluster.", (Object)alert.getName(), (Object)hostName);
                return false;
            }
            return true;
        }
        if (StringUtils.isNotBlank((String)hostName)) {
            if (!clusters.hostExists(hostName)) {
                LOG.warn("Unable to process alert {} for an invalid host named {}", (Object)alert.getName(), (Object)hostName);
                return false;
            }
            if (!cluster.getServices().containsKey(serviceName)) {
                LOG.warn("Unable to process alert {} for an invalid service named {}", (Object)alert.getName(), (Object)serviceName);
                return false;
            }
            if (null != componentName && !cluster.getHosts(serviceName, componentName).contains(hostName)) {
                LOG.warn("Unable to process alert {} for an invalid service {} and component {} on host {}", new Object[]{alert.getName(), serviceName, componentName, hostName});
                return false;
            }
        }
        return true;
    }

    private AlertHistoryEntity createHistory(long clusterId, AlertDefinitionEntity definition, Alert alert) {
        AlertHistoryEntity history = new AlertHistoryEntity();
        history.setAlertDefinition(definition);
        history.setAlertDefinitionId(definition.getDefinitionId());
        history.setAlertLabel(definition.getLabel());
        history.setAlertInstance(alert.getInstance());
        history.setAlertState(alert.getState());
        history.setAlertText(alert.getText());
        history.setAlertTimestamp(alert.getTimestamp());
        history.setClusterId(clusterId);
        history.setComponentName(alert.getComponent());
        history.setServiceName(alert.getService());
        if (definition.isHostIgnored()) {
            history.setHostName(null);
        } else {
            history.setHostName(alert.getHostName());
        }
        return history;
    }

    private AlertFirmness calculateFirmnessForStateChange(Long clusterId, AlertDefinitionEntity definition, AlertState state, long occurrences) {
        if (state == AlertState.OK) {
            return AlertFirmness.HARD;
        }
        if (definition.getSourceType() == SourceType.AGGREGATE) {
            return AlertFirmness.HARD;
        }
        int tolerance = this.getRepeatTolerance(definition, clusterId);
        if (tolerance <= 1) {
            return AlertFirmness.HARD;
        }
        if ((long)tolerance <= occurrences) {
            return AlertFirmness.HARD;
        }
        return AlertFirmness.SOFT;
    }

    private int getRepeatTolerance(AlertDefinitionEntity definition, Long clusterId) {
        if (definition.isRepeatToleranceEnabled()) {
            return definition.getRepeatTolerance();
        }
        int repeatTolerance = 1;
        try {
            Cluster cluster = ((Clusters)this.m_clusters.get()).getCluster(clusterId);
            String value = cluster.getClusterProperty("alerts_repeat_tolerance", "1");
            repeatTolerance = NumberUtils.toInt((String)value, (int)1);
        }
        catch (OBDPException ambariException) {
            String msg = String.format("Unable to read %s/%s from cluster %s, defaulting to 1", "cluster-env", "alerts_repeat_tolerance", clusterId);
            LOG.warn(msg, (Throwable)ambariException);
        }
        return repeatTolerance;
    }
}

