/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.events.listeners.alerts;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import id.onyx.obdp.server.EagerSingleton;
import id.onyx.obdp.server.api.query.render.AlertSummaryGroupedRenderer;
import id.onyx.obdp.server.events.AggregateAlertRecalculateEvent;
import id.onyx.obdp.server.events.AlertUpdateEvent;
import id.onyx.obdp.server.events.MaintenanceModeEvent;
import id.onyx.obdp.server.events.publishers.AlertEventPublisher;
import id.onyx.obdp.server.events.publishers.OBDPEventPublisher;
import id.onyx.obdp.server.events.publishers.STOMPUpdatePublisher;
import id.onyx.obdp.server.orm.dao.AlertsDAO;
import id.onyx.obdp.server.orm.entities.AlertCurrentEntity;
import id.onyx.obdp.server.orm.entities.AlertDefinitionEntity;
import id.onyx.obdp.server.orm.entities.AlertHistoryEntity;
import id.onyx.obdp.server.state.AlertState;
import id.onyx.obdp.server.state.Host;
import id.onyx.obdp.server.state.MaintenanceState;
import id.onyx.obdp.server.state.Service;
import id.onyx.obdp.server.state.ServiceComponentHost;
import id.onyx.obdp.server.state.alert.AggregateDefinitionMapping;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@EagerSingleton
public class AlertMaintenanceModeListener {
    private static final Logger LOG = LoggerFactory.getLogger(AlertMaintenanceModeListener.class);
    @Inject
    private AlertEventPublisher m_alertEventPublisher;
    @Inject
    private AlertsDAO m_alertsDao = null;
    @Inject
    private AggregateDefinitionMapping m_aggregateMapping;
    @Inject
    private STOMPUpdatePublisher STOMPUpdatePublisher;
    private long clusterId = -1L;

    @Inject
    public AlertMaintenanceModeListener(OBDPEventPublisher publisher) {
        publisher.register(this);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onEvent(MaintenanceModeEvent event) {
        LOG.debug("Received event {}", (Object)event);
        boolean recalculateAggregateAlert = false;
        List<AlertCurrentEntity> currentAlerts = this.m_alertsDao.findCurrent();
        MaintenanceState newMaintenanceState = MaintenanceState.OFF;
        if (event.getMaintenanceState() != MaintenanceState.OFF) {
            newMaintenanceState = MaintenanceState.ON;
        }
        HashMap<Long, Map<String, AlertSummaryGroupedRenderer.AlertDefinitionSummary>> alertUpdates = new HashMap<Long, Map<String, AlertSummaryGroupedRenderer.AlertDefinitionSummary>>();
        for (AlertCurrentEntity currentAlert : currentAlerts) {
            AlertHistoryEntity history = currentAlert.getAlertHistory();
            String alertHostName = history.getHostName();
            String alertServiceName = history.getServiceName();
            String alertComponentName = history.getComponentName();
            try {
                String hostName;
                Host host = event.getHost();
                Service service = event.getService();
                ServiceComponentHost serviceComponentHost = event.getServiceComponentHost();
                if (null != host) {
                    hostName = host.getHostName();
                    if (!hostName.equals(alertHostName) || !this.updateMaintenanceStateAndRecalculateAggregateAlert(history, currentAlert, newMaintenanceState, alertUpdates)) continue;
                    recalculateAggregateAlert = true;
                    continue;
                }
                if (null != service) {
                    String serviceName = service.getName();
                    if (!serviceName.equals(alertServiceName) || !this.updateMaintenanceStateAndRecalculateAggregateAlert(history, currentAlert, newMaintenanceState, alertUpdates)) continue;
                    recalculateAggregateAlert = true;
                    continue;
                }
                if (null == serviceComponentHost) continue;
                hostName = serviceComponentHost.getHostName();
                String serviceName = serviceComponentHost.getServiceName();
                String componentName = serviceComponentHost.getServiceComponentName();
                if (!hostName.equals(alertHostName) || !serviceName.equals(alertServiceName) || !componentName.equals(alertComponentName) || !this.updateMaintenanceStateAndRecalculateAggregateAlert(history, currentAlert, newMaintenanceState, alertUpdates)) continue;
                recalculateAggregateAlert = true;
            }
            catch (Exception exception) {
                AlertDefinitionEntity definition = history.getAlertDefinition();
                LOG.error("Unable to put alert '{}' for host {} into maintenance mode", new Object[]{definition.getDefinitionName(), alertHostName, exception});
            }
        }
        if (!alertUpdates.isEmpty()) {
            this.STOMPUpdatePublisher.publish(new AlertUpdateEvent(alertUpdates));
        }
        if (recalculateAggregateAlert) {
            this.m_alertEventPublisher.publish(new AggregateAlertRecalculateEvent(this.clusterId));
        }
    }

    private boolean updateMaintenanceStateAndRecalculateAggregateAlert(AlertHistoryEntity historyAlert, AlertCurrentEntity currentAlert, MaintenanceState maintenanceState, Map<Long, Map<String, AlertSummaryGroupedRenderer.AlertDefinitionSummary>> alertUpdates) {
        AlertDefinitionEntity definitionEntity = currentAlert.getAlertHistory().getAlertDefinition();
        if (maintenanceState != MaintenanceState.OFF && maintenanceState != MaintenanceState.ON) {
            LOG.warn("Unable to set invalid maintenance state of {} on the alert {}", (Object)maintenanceState, (Object)definitionEntity.getDefinitionName());
            return false;
        }
        MaintenanceState currentState = currentAlert.getMaintenanceState();
        if (currentState == maintenanceState) {
            return false;
        }
        currentAlert.setMaintenanceState(maintenanceState);
        this.m_alertsDao.merge(currentAlert);
        AlertState alertState = historyAlert.getAlertState();
        if (!alertUpdates.containsKey(historyAlert.getClusterId())) {
            alertUpdates.put(historyAlert.getClusterId(), new HashMap());
        }
        Map<String, AlertSummaryGroupedRenderer.AlertDefinitionSummary> summaries = alertUpdates.get(historyAlert.getClusterId());
        AlertSummaryGroupedRenderer.updateSummary(summaries, definitionEntity.getDefinitionId(), definitionEntity.getDefinitionName(), alertState, -1L, maintenanceState, "");
        if (AlertState.RECALCULATE_AGGREGATE_ALERT_STATES.contains((Object)alertState)) {
            this.clusterId = historyAlert.getClusterId();
            String alertName = historyAlert.getAlertDefinition().getDefinitionName();
            if (this.m_aggregateMapping.getAggregateDefinition(this.clusterId, alertName) != null) {
                return true;
            }
        }
        return false;
    }
}

