/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.events.listeners.alerts;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import id.onyx.obdp.server.EagerSingleton;
import id.onyx.obdp.server.events.AlertDefinitionChangedEvent;
import id.onyx.obdp.server.events.AlertDefinitionDeleteEvent;
import id.onyx.obdp.server.events.AlertDefinitionRegistrationEvent;
import id.onyx.obdp.server.events.AlertHashInvalidationEvent;
import id.onyx.obdp.server.events.publishers.OBDPEventPublisher;
import id.onyx.obdp.server.orm.dao.AlertsDAO;
import id.onyx.obdp.server.orm.entities.AlertCurrentEntity;
import id.onyx.obdp.server.orm.entities.AlertHistoryEntity;
import id.onyx.obdp.server.state.alert.AggregateDefinitionMapping;
import id.onyx.obdp.server.state.alert.AlertDefinition;
import id.onyx.obdp.server.state.alert.AlertDefinitionHash;
import id.onyx.obdp.server.state.alert.SourceType;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@EagerSingleton
public class AlertLifecycleListener {
    private static final Logger LOG = LoggerFactory.getLogger(AlertLifecycleListener.class);
    @Inject
    private AggregateDefinitionMapping m_aggregateMapping;
    @Inject
    private Provider<AlertDefinitionHash> m_alertDefinitionHash;
    @Inject
    private OBDPEventPublisher m_eventPublisher;
    @Inject
    private AlertsDAO m_alertsDao;

    @Inject
    public AlertLifecycleListener(OBDPEventPublisher publisher) {
        publisher.register(this);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onAmbariEvent(AlertDefinitionRegistrationEvent event) {
        LOG.debug("Received event {}", (Object)event);
        AlertDefinition definition = event.getDefinition();
        LOG.debug("Registering alert definition {}", (Object)definition);
        if (definition.getSource().getType() == SourceType.AGGREGATE) {
            this.m_aggregateMapping.registerAggregate(event.getClusterId(), definition);
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onAmbariEvent(AlertDefinitionChangedEvent event) {
        LOG.debug("Received event {}", (Object)event);
        AlertDefinition definition = event.getDefinition();
        LOG.debug("Updating alert definition {}", (Object)definition);
        if (definition.getSource().getType() == SourceType.AGGREGATE) {
            this.m_aggregateMapping.registerAggregate(event.getClusterId(), definition);
        }
        List<AlertCurrentEntity> currentAlerts = this.m_alertsDao.findCurrentByDefinitionId(definition.getDefinitionId());
        for (AlertCurrentEntity current : currentAlerts) {
            AlertHistoryEntity history = current.getAlertHistory();
            if (StringUtils.equals((String)definition.getLabel(), (String)history.getAlertLabel())) continue;
            history.setAlertLabel(definition.getLabel());
            this.m_alertsDao.merge(history);
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onAmbariEvent(AlertDefinitionDeleteEvent event) {
        LOG.debug("Received event {}", (Object)event);
        AlertDefinition definition = event.getDefinition();
        LOG.debug("Removing alert definition {}", (Object)definition);
        if (null == definition) {
            return;
        }
        this.m_aggregateMapping.removeAssociatedAggregate(event.getClusterId(), definition.getName());
        AlertDefinitionHash hashHelper = (AlertDefinitionHash)this.m_alertDefinitionHash.get();
        Set<String> invalidatedHosts = hashHelper.invalidateHosts(definition);
        AlertHashInvalidationEvent hashInvalidationEvent = new AlertHashInvalidationEvent(definition.getClusterId(), invalidatedHosts);
        this.m_eventPublisher.publish(hashInvalidationEvent);
    }
}

