/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.events.listeners.alerts;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import id.onyx.obdp.server.EagerSingleton;
import id.onyx.obdp.server.events.AlertHashInvalidationEvent;
import id.onyx.obdp.server.events.HostsAddedEvent;
import id.onyx.obdp.server.events.HostsRemovedEvent;
import id.onyx.obdp.server.events.publishers.OBDPEventPublisher;
import id.onyx.obdp.server.metadata.OBDPServiceAlertDefinitions;
import id.onyx.obdp.server.orm.dao.AlertDefinitionDAO;
import id.onyx.obdp.server.orm.dao.AlertsDAO;
import id.onyx.obdp.server.orm.entities.AlertDefinitionEntity;
import id.onyx.obdp.server.state.alert.AlertDefinition;
import id.onyx.obdp.server.state.alert.AlertDefinitionFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@EagerSingleton
public class AlertHostListener {
    private static final Logger LOG = LoggerFactory.getLogger(AlertHostListener.class);
    @Inject
    private AlertsDAO m_alertsDao;
    @Inject
    private AlertDefinitionDAO m_alertDefinitionDao;
    @Inject
    private OBDPEventPublisher m_eventPublisher;
    @Inject
    private OBDPServiceAlertDefinitions m_ambariServiceAlertDefinitions;
    @Inject
    private AlertDefinitionFactory m_alertDefinitionFactory;
    private Lock m_hostAlertLock = new ReentrantLock();

    @Inject
    public AlertHostListener(OBDPEventPublisher publisher) {
        publisher.register(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Subscribe
    @AllowConcurrentEvents
    public void onAmbariEvent(HostsAddedEvent event) {
        LOG.debug("Received event {}", (Object)event);
        long clusterId = event.getClusterId();
        List<AlertDefinition> agentDefinitions = this.m_ambariServiceAlertDefinitions.getAgentDefinitions();
        List<AlertDefinition> serverDefinitions = this.m_ambariServiceAlertDefinitions.getServerDefinitions();
        ArrayList<AlertDefinition> ambariServiceDefinitions = new ArrayList<AlertDefinition>();
        ambariServiceDefinitions.addAll(agentDefinitions);
        ambariServiceDefinitions.addAll(serverDefinitions);
        this.m_hostAlertLock.lock();
        try {
            for (AlertDefinition agentDefinition : ambariServiceDefinitions) {
                AlertDefinitionEntity definition = this.m_alertDefinitionDao.findByName(clusterId, agentDefinition.getName());
                if (null != definition) continue;
                definition = this.m_alertDefinitionFactory.coerce(clusterId, agentDefinition);
                try {
                    this.m_alertDefinitionDao.create(definition);
                }
                catch (Exception e) {
                    LOG.error("Unable to create an alert definition named {} in cluster {}", new Object[]{definition.getDefinitionName(), definition.getClusterId(), e});
                }
            }
        }
        finally {
            this.m_hostAlertLock.unlock();
        }
        for (String hostName : event.getHostNames()) {
            AlertHashInvalidationEvent invalidationEvent = new AlertHashInvalidationEvent(event.getClusterId(), Collections.singletonList(hostName));
            this.m_eventPublisher.publish(invalidationEvent);
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onAmbariEvent(HostsRemovedEvent event) {
        LOG.debug("Received event {}", (Object)event);
        for (String hostName : event.getHostNames()) {
            this.m_alertsDao.removeCurrentByHost(hostName);
        }
    }
}

