/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.events.listeners.alerts;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import id.onyx.obdp.server.EagerSingleton;
import id.onyx.obdp.server.events.AlertHashInvalidationEvent;
import id.onyx.obdp.server.events.ClusterEvent;
import id.onyx.obdp.server.events.OBDPEvent;
import id.onyx.obdp.server.events.ServiceComponentUninstalledEvent;
import id.onyx.obdp.server.events.publishers.OBDPEventPublisher;
import id.onyx.obdp.server.state.alert.AlertDefinitionHash;
import java.util.Collection;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@EagerSingleton
public class AlertHashInvalidationListener {
    private static final Logger LOG = LoggerFactory.getLogger(AlertHashInvalidationListener.class);
    @Inject
    private Provider<AlertDefinitionHash> m_alertDefinitionHash;

    @Inject
    public AlertHashInvalidationListener(OBDPEventPublisher publisher) {
        publisher.register(this);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onAmbariEvent(AlertHashInvalidationEvent event) {
        LOG.debug("Received event {}", (Object)event);
        Collection<String> hosts = event.getHosts();
        long clusterId = event.getClusterId();
        if (null == hosts || hosts.isEmpty()) {
            return;
        }
        AlertDefinitionHash hash = (AlertDefinitionHash)this.m_alertDefinitionHash.get();
        hash.enqueueAgentCommands(clusterId, hosts);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onEvent(ServiceComponentUninstalledEvent event) {
        LOG.debug("Received event {}", (Object)event);
        long clusterId = event.getClusterId();
        String hostName = event.getHostName();
        if (null == hostName) {
            return;
        }
        ((AlertDefinitionHash)this.m_alertDefinitionHash.get()).invalidate(hostName);
        ((AlertDefinitionHash)this.m_alertDefinitionHash.get()).enqueueAgentCommands(clusterId, Collections.singletonList(hostName));
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onAmbariEvent(ClusterEvent event) {
        LOG.debug("Received event {}", (Object)event);
        if (event.getType() != OBDPEvent.OBDPEventType.CLUSTER_RENAME) {
            return;
        }
        AlertDefinitionHash hash = (AlertDefinitionHash)this.m_alertDefinitionHash.get();
        hash.invalidateAll();
        long clusterId = event.getClusterId();
        hash.enqueueAgentCommands(clusterId);
    }
}

