/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.events.listeners.alerts;

import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import id.onyx.obdp.server.EagerSingleton;
import id.onyx.obdp.server.agent.stomp.dto.AlertGroupUpdate;
import id.onyx.obdp.server.events.AlertDefinitionDeleteEvent;
import id.onyx.obdp.server.events.AlertGroupsUpdateEvent;
import id.onyx.obdp.server.events.UpdateEventType;
import id.onyx.obdp.server.events.publishers.OBDPEventPublisher;
import id.onyx.obdp.server.events.publishers.STOMPUpdatePublisher;
import id.onyx.obdp.server.orm.dao.AlertDispatchDAO;
import id.onyx.obdp.server.orm.entities.AlertDefinitionEntity;
import id.onyx.obdp.server.orm.entities.AlertGroupEntity;
import java.util.ArrayList;
import java.util.Objects;

@Singleton
@EagerSingleton
public class AlertGroupsUpdateListener {
    @Inject
    private STOMPUpdatePublisher STOMPUpdatePublisher;
    @Inject
    private AlertDispatchDAO alertDispatchDAO;

    @Inject
    public AlertGroupsUpdateListener(OBDPEventPublisher ambariEventPublisher) {
        ambariEventPublisher.register(this);
    }

    @Subscribe
    public void onAlertDefinitionDeleted(AlertDefinitionDeleteEvent event) {
        ArrayList<AlertGroupUpdate> alertGroupUpdates = new ArrayList<AlertGroupUpdate>();
        for (AlertGroupEntity alertGroupEntity : this.alertDispatchDAO.findAllGroups(event.getClusterId())) {
            boolean eventAffectsGroup = alertGroupEntity.getAlertDefinitions().stream().map(AlertDefinitionEntity::getDefinitionId).anyMatch(each -> Objects.equals(each, event.getDefinition().getDefinitionId()));
            if (!eventAffectsGroup) continue;
            AlertGroupUpdate alertGroupUpdate = new AlertGroupUpdate(alertGroupEntity);
            alertGroupUpdate.getTargets().remove(event.getDefinition().getDefinitionId());
            alertGroupUpdates.add(alertGroupUpdate);
        }
        this.STOMPUpdatePublisher.publish(new AlertGroupsUpdateEvent(alertGroupUpdates, UpdateEventType.UPDATE));
    }
}

