/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.events.listeners.alerts;

import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import id.onyx.obdp.server.EagerSingleton;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.agent.stomp.AlertDefinitionsHolder;
import id.onyx.obdp.server.agent.stomp.dto.AlertCluster;
import id.onyx.obdp.server.events.AlertDefinitionChangedEvent;
import id.onyx.obdp.server.events.AlertDefinitionDeleteEvent;
import id.onyx.obdp.server.events.AlertDefinitionEventType;
import id.onyx.obdp.server.events.AlertDefinitionRegistrationEvent;
import id.onyx.obdp.server.events.AlertDefinitionsUIUpdateEvent;
import id.onyx.obdp.server.events.ServiceComponentInstalledEvent;
import id.onyx.obdp.server.events.ServiceComponentUninstalledEvent;
import id.onyx.obdp.server.events.publishers.OBDPEventPublisher;
import id.onyx.obdp.server.events.publishers.STOMPUpdatePublisher;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.Host;
import id.onyx.obdp.server.state.alert.AlertDefinition;
import id.onyx.obdp.server.state.alert.AlertDefinitionHash;
import id.onyx.obdp.server.state.alert.AlertHelper;
import jakarta.inject.Provider;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@EagerSingleton
public class AlertDefinitionsUIUpdateListener {
    private static final Logger LOG = LoggerFactory.getLogger(AlertDefinitionsUIUpdateListener.class);
    @Inject
    private Provider<AlertDefinitionHash> helper;
    @Inject
    private Provider<Clusters> clusters;
    @Inject
    private STOMPUpdatePublisher STOMPUpdatePublisher;
    @Inject
    private AlertDefinitionsHolder alertDefinitionsHolder;
    @Inject
    private AlertHelper alertHelper;
    public static final String AMBARI_STALE_ALERT_NAME = "ambari_server_stale_alerts";

    @Inject
    public AlertDefinitionsUIUpdateListener(OBDPEventPublisher ambariEventPublisher) {
        ambariEventPublisher.register(this);
    }

    @Subscribe
    public void onAlertDefinitionRegistered(AlertDefinitionRegistrationEvent event) throws OBDPException {
        this.handleSingleDefinitionChange(AlertDefinitionEventType.UPDATE, event.getDefinition());
    }

    @Subscribe
    public void onAlertDefinitionChanged(AlertDefinitionChangedEvent event) throws OBDPException {
        this.handleSingleDefinitionChange(AlertDefinitionEventType.UPDATE, event.getDefinition());
    }

    @Subscribe
    public void onAlertDefinitionDeleted(AlertDefinitionDeleteEvent event) throws OBDPException {
        this.handleSingleDefinitionChange(AlertDefinitionEventType.DELETE, event.getDefinition());
    }

    @Subscribe
    public void onServiceComponentInstalled(ServiceComponentInstalledEvent event) throws OBDPException {
        String hostName = event.getHostName();
        String serviceName = event.getServiceName();
        String componentName = event.getComponentName();
        Map<Long, AlertDefinition> definitions = ((AlertDefinitionHash)this.helper.get()).findByServiceComponent(event.getClusterId(), serviceName, componentName);
        if (event.isMasterComponent()) {
            try {
                Cluster cluster = ((Clusters)this.clusters.get()).getClusterById(event.getClusterId());
                if (cluster.getService(serviceName).getServiceComponents().get(componentName).getServiceComponentHosts().containsKey(hostName)) {
                    definitions.putAll(((AlertDefinitionHash)this.helper.get()).findByServiceMaster(event.getClusterId(), serviceName));
                }
            }
            catch (OBDPException e) {
                String msg = String.format("Failed to get alert definitions for master component %s/%s", serviceName, componentName);
                LOG.warn(msg, (Throwable)e);
            }
        }
        if (!definitions.isEmpty()) {
            this.alertDefinitionsHolder.provideAlertDefinitionAgentUpdateEvent(AlertDefinitionEventType.UPDATE, event.getClusterId(), definitions, hostName);
            Map<Long, AlertCluster> map = Collections.singletonMap(event.getClusterId(), new AlertCluster(definitions, hostName));
            this.STOMPUpdatePublisher.publish(new AlertDefinitionsUIUpdateEvent(AlertDefinitionEventType.UPDATE, map));
        }
    }

    @Subscribe
    public void onServiceComponentUninstalled(ServiceComponentUninstalledEvent event) throws OBDPException {
        String hostName = event.getHostName();
        Map<Long, AlertDefinition> definitions = ((AlertDefinitionHash)this.helper.get()).findByServiceComponent(event.getClusterId(), event.getServiceName(), event.getComponentName());
        if (event.isMasterComponent()) {
            definitions.putAll(((AlertDefinitionHash)this.helper.get()).findByServiceMaster(event.getClusterId(), event.getServiceName()));
        }
        if (!definitions.isEmpty()) {
            this.alertDefinitionsHolder.provideAlertDefinitionAgentUpdateEvent(AlertDefinitionEventType.DELETE, event.getClusterId(), definitions, hostName);
            Map<Long, AlertCluster> map = Collections.singletonMap(event.getClusterId(), new AlertCluster(definitions, hostName));
            this.STOMPUpdatePublisher.publish(new AlertDefinitionsUIUpdateEvent(AlertDefinitionEventType.DELETE, map));
        }
    }

    private void handleSingleDefinitionChange(AlertDefinitionEventType eventType, AlertDefinition alertDefinition) throws OBDPException {
        LOG.info("{} alert definition '{}'", (Object)eventType, (Object)alertDefinition);
        Cluster cluster = ((Clusters)this.clusters.get()).getCluster(alertDefinition.getClusterId());
        ((AlertDefinitionHash)this.helper.get()).invalidateHosts(alertDefinition);
        for (String hostName : alertDefinition.matchingHosts((Clusters)this.clusters.get())) {
            this.alertDefinitionsHolder.provideAlertDefinitionAgentUpdateEvent(eventType, alertDefinition.getClusterId(), Collections.singletonMap(alertDefinition.getDefinitionId(), alertDefinition), hostName);
        }
        if (alertDefinition.getName().equals(AMBARI_STALE_ALERT_NAME)) {
            for (Host host : cluster.getHosts()) {
                this.alertDefinitionsHolder.provideStaleAlertDefinitionUpdateEvent(eventType, alertDefinition.getClusterId(), this.alertHelper.getWaitFactorMultiplier(alertDefinition), host.getHostName());
            }
        }
        Map<Long, AlertCluster> update = Collections.singletonMap(alertDefinition.getClusterId(), new AlertCluster(alertDefinition, null));
        AlertDefinitionsUIUpdateEvent event = new AlertDefinitionsUIUpdateEvent(eventType, update);
        this.STOMPUpdatePublisher.publish(event);
    }
}

