/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.events.listeners.alerts;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import id.onyx.obdp.server.EagerSingleton;
import id.onyx.obdp.server.api.query.render.AlertSummaryGroupedRenderer;
import id.onyx.obdp.server.events.AlertDefinitionDisabledEvent;
import id.onyx.obdp.server.events.AlertUpdateEvent;
import id.onyx.obdp.server.events.publishers.OBDPEventPublisher;
import id.onyx.obdp.server.events.publishers.STOMPUpdatePublisher;
import id.onyx.obdp.server.orm.dao.AlertsDAO;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EagerSingleton
public class AlertDefinitionDisabledListener {
    private static final Logger LOG = LoggerFactory.getLogger(AlertDefinitionDisabledListener.class);
    @Inject
    private AlertsDAO m_alertsDao = null;
    @Inject
    private STOMPUpdatePublisher STOMPUpdatePublisher;

    @Inject
    public AlertDefinitionDisabledListener(OBDPEventPublisher publisher) {
        publisher.register(this);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onEvent(AlertDefinitionDisabledEvent event) {
        LOG.debug("Received event {}", (Object)event);
        this.m_alertsDao.removeCurrentDisabledAlerts();
        HashMap<Long, Map<String, AlertSummaryGroupedRenderer.AlertDefinitionSummary>> alertUpdates = new HashMap<Long, Map<String, AlertSummaryGroupedRenderer.AlertDefinitionSummary>>();
        alertUpdates.put(event.getClusterId(), AlertSummaryGroupedRenderer.generateEmptySummary(event.getDefinitionId(), event.getDefinitionName()));
        this.STOMPUpdatePublisher.publish(new AlertUpdateEvent(alertUpdates));
    }
}

