/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.events.listeners.alerts;

import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import id.onyx.obdp.server.EagerSingleton;
import id.onyx.obdp.server.events.AggregateAlertRecalculateEvent;
import id.onyx.obdp.server.events.AlertReceivedEvent;
import id.onyx.obdp.server.events.AlertStateChangeEvent;
import id.onyx.obdp.server.events.InitialAlertEvent;
import id.onyx.obdp.server.events.publishers.AlertEventPublisher;
import id.onyx.obdp.server.orm.dao.AlertSummaryDTO;
import id.onyx.obdp.server.orm.dao.AlertsDAO;
import id.onyx.obdp.server.orm.entities.AlertCurrentEntity;
import id.onyx.obdp.server.state.Alert;
import id.onyx.obdp.server.state.AlertFirmness;
import id.onyx.obdp.server.state.AlertState;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.alert.AggregateDefinitionMapping;
import id.onyx.obdp.server.state.alert.AggregateSource;
import id.onyx.obdp.server.state.alert.AlertDefinition;
import id.onyx.obdp.server.state.alert.Reporting;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@EagerSingleton
public class AlertAggregateListener {
    private static final Logger LOG = LoggerFactory.getLogger(AlertAggregateListener.class);
    @Inject
    private AlertsDAO m_alertsDao = null;
    @Inject
    Provider<Clusters> m_clusters;
    private final AlertEventPublisher m_publisher;
    private Map<String, Alert> m_alertCache = new ConcurrentHashMap<String, Alert>();
    @Inject
    private AggregateDefinitionMapping m_aggregateMapping;

    @Inject
    public AlertAggregateListener(AlertEventPublisher publisher) {
        this.m_publisher = publisher;
        this.m_publisher.register(this);
    }

    @Subscribe
    public void onInitialAlertEvent(InitialAlertEvent event) {
        LOG.debug("Received event {}", (Object)event);
        this.onAlertEvent(event.getClusterId(), event.getAlert().getName());
    }

    @Subscribe
    public void onAlertStateChangeEvent(AlertStateChangeEvent event) {
        LOG.debug("Received event {}", (Object)event);
        AlertCurrentEntity currentEntity = event.getCurrentAlert();
        if (currentEntity.getFirmness() == AlertFirmness.SOFT) {
            return;
        }
        this.onAlertEvent(event.getClusterId(), event.getAlert().getName());
    }

    @Subscribe
    public void onAlertStateChangeEvent(AggregateAlertRecalculateEvent event) {
        LOG.debug("Received event {}", (Object)event);
        List<String> alertNames = this.m_aggregateMapping.getAlertsWithAggregates(event.getClusterId());
        for (String alertName : alertNames) {
            this.onAlertEvent(event.getClusterId(), alertName);
        }
    }

    private void onAlertEvent(long clusterId, String alertName) {
        AlertDefinition aggregateDefinition = this.m_aggregateMapping.getAggregateDefinition(clusterId, alertName);
        if (null == aggregateDefinition || null == this.m_alertsDao) {
            return;
        }
        AggregateSource aggregateSource = (AggregateSource)aggregateDefinition.getSource();
        AlertSummaryDTO summary = this.m_alertsDao.findAggregateCounts(clusterId, aggregateSource.getAlertName());
        int okCount = summary.getOkCount() + summary.getMaintenanceCount();
        int warningCount = summary.getWarningCount();
        int criticalCount = summary.getCriticalCount();
        int unknownCount = summary.getUnknownCount();
        int totalCount = okCount + warningCount + criticalCount + unknownCount;
        Alert aggregateAlert = new Alert(aggregateDefinition.getName(), null, aggregateDefinition.getServiceName(), null, null, AlertState.UNKNOWN);
        aggregateAlert.setLabel(aggregateDefinition.getLabel());
        aggregateAlert.setTimestamp(System.currentTimeMillis());
        aggregateAlert.setClusterId(clusterId);
        if (0 == totalCount) {
            aggregateAlert.setText("There are no instances of the aggregated alert.");
        } else if (summary.getUnknownCount() > 0) {
            aggregateAlert.setText("There are alerts with a state of UNKNOWN.");
        } else {
            Reporting reporting = aggregateSource.getReporting();
            int numerator = summary.getCriticalCount() + summary.getWarningCount();
            int denominator = totalCount;
            double value = (double)numerator / (double)denominator;
            if (Reporting.ReportingType.PERCENT.equals((Object)reporting.getType())) {
                value *= 100.0;
            }
            if (value >= reporting.getCritical().getValue()) {
                aggregateAlert.setState(AlertState.CRITICAL);
                aggregateAlert.setText(MessageFormat.format(reporting.getCritical().getText(), denominator, numerator));
            } else if (value >= reporting.getWarning().getValue()) {
                aggregateAlert.setState(AlertState.WARNING);
                aggregateAlert.setText(MessageFormat.format(reporting.getWarning().getText(), denominator, numerator));
            } else {
                aggregateAlert.setState(AlertState.OK);
                aggregateAlert.setText(MessageFormat.format(reporting.getOk().getText(), denominator, numerator));
            }
        }
        boolean sendAlertEvent = true;
        Alert cachedAlert = this.m_alertCache.get(aggregateAlert.getName());
        if (null != cachedAlert) {
            AlertState cachedState = cachedAlert.getState();
            AlertState alertState = aggregateAlert.getState();
            String cachedText = cachedAlert.getText();
            String alertText = aggregateAlert.getText();
            if (cachedState == alertState && StringUtils.equals((String)cachedText, (String)alertText)) {
                sendAlertEvent = false;
            }
        }
        this.m_alertCache.put(aggregateAlert.getName(), aggregateAlert);
        if (sendAlertEvent) {
            AlertReceivedEvent aggEvent = new AlertReceivedEvent(clusterId, aggregateAlert);
            this.m_publisher.publish(aggEvent);
        }
    }
}

