/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.events;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import id.onyx.obdp.server.actionmanager.HostRoleStatus;
import id.onyx.obdp.server.controller.internal.CalculatedStatus;
import id.onyx.obdp.server.controller.internal.UpgradeResourceProvider;
import id.onyx.obdp.server.events.STOMPEvent;
import id.onyx.obdp.server.events.UpdateEventType;
import id.onyx.obdp.server.orm.dao.HostRoleCommandDAO;
import id.onyx.obdp.server.orm.dao.HostRoleCommandStatusSummaryDTO;
import id.onyx.obdp.server.orm.dao.RequestDAO;
import id.onyx.obdp.server.orm.entities.RequestEntity;
import id.onyx.obdp.server.orm.entities.UpgradeEntity;
import id.onyx.obdp.server.stack.upgrade.Direction;
import id.onyx.obdp.spi.upgrade.UpgradeType;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class UpgradeUpdateEvent
extends STOMPEvent {
    @JsonProperty(value="associated_version")
    private String associatedVersion;
    @JsonProperty(value="cluster_id")
    private Long clusterId;
    @JsonProperty(value="direction")
    private Direction direction;
    @JsonProperty(value="downgrade_allowed")
    private Boolean downgradeAllowed;
    @JsonProperty(value="request_id")
    private Long requestId;
    @JsonProperty(value="request_status")
    private HostRoleStatus requestStatus;
    @JsonProperty(value="skip_failures")
    private Boolean skipFailures;
    @JsonProperty(value="skip_service_check_failures")
    private Boolean skipServiceCheckFailures;
    @JsonProperty(value="upgrade_type")
    private UpgradeType upgradeType;
    @JsonProperty(value="start_time")
    private Long startTime;
    @JsonProperty(value="end_time")
    private Long endTime;
    @JsonProperty(value="upgrade_id")
    private Long upgradeId;
    @JsonProperty(value="suspended")
    private Boolean suspended;
    @JsonProperty(value="progress_percent")
    private Double progressPercent;
    @JsonProperty(value="revert_allowed")
    private Boolean revertAllowed;
    @JsonProperty(value="type")
    private UpdateEventType type;

    private UpgradeUpdateEvent(UpdateEventType type) {
        super(STOMPEvent.Type.UPGRADE);
        this.type = type;
    }

    public static UpgradeUpdateEvent formFullEvent(HostRoleCommandDAO hostRoleCommandDAO, RequestDAO requestDAO, UpgradeEntity upgradeEntity, UpdateEventType type) {
        double progressPercent;
        UpgradeUpdateEvent upgradeUpdateEvent = new UpgradeUpdateEvent(UpdateEventType.CREATE);
        Map<Long, HostRoleCommandStatusSummaryDTO> summary = hostRoleCommandDAO.findAggregateCounts(upgradeEntity.getRequestId());
        CalculatedStatus calc = CalculatedStatus.statusFromStageSummary(summary, summary.keySet());
        if (calc.getStatus() == HostRoleStatus.ABORTED && upgradeEntity.isSuspended()) {
            double percent = UpgradeResourceProvider.calculateAbortedProgress(summary);
            progressPercent = percent * 100.0;
        } else {
            progressPercent = calc.getPercent();
        }
        RequestEntity rentity = requestDAO.findByPK(upgradeEntity.getRequestId());
        upgradeUpdateEvent.setUpgradeId(upgradeEntity.getId());
        upgradeUpdateEvent.setAssociatedVersion(upgradeEntity.getRepositoryVersion().getVersion());
        upgradeUpdateEvent.setClusterId(upgradeEntity.getClusterId());
        upgradeUpdateEvent.setDirection(upgradeEntity.getDirection());
        upgradeUpdateEvent.setDowngradeAllowed(upgradeEntity.isDowngradeAllowed());
        upgradeUpdateEvent.setRequestId(upgradeEntity.getRequestId());
        upgradeUpdateEvent.setRequestStatus(calc.getStatus());
        upgradeUpdateEvent.setSkipFailures(upgradeEntity.isComponentFailureAutoSkipped());
        upgradeUpdateEvent.setSkipServiceCheckFailures(upgradeEntity.isServiceCheckFailureAutoSkipped());
        upgradeUpdateEvent.setUpgradeType(upgradeEntity.getUpgradeType());
        upgradeUpdateEvent.setStartTime(rentity.getStartTime());
        upgradeUpdateEvent.setEndTime(rentity.getEndTime());
        upgradeUpdateEvent.setSuspended(upgradeEntity.isSuspended());
        upgradeUpdateEvent.setProgressPercent(progressPercent);
        upgradeUpdateEvent.setRevertAllowed(upgradeEntity.isRevertAllowed());
        return upgradeUpdateEvent;
    }

    public static UpgradeUpdateEvent formUpdateEvent(HostRoleCommandDAO hostRoleCommandDAO, RequestDAO requestDAO, UpgradeEntity upgradeEntity) {
        double progressPercent;
        Map<Long, HostRoleCommandStatusSummaryDTO> summary = hostRoleCommandDAO.findAggregateCounts(upgradeEntity.getRequestId());
        CalculatedStatus calc = CalculatedStatus.statusFromStageSummary(summary, summary.keySet());
        if (calc.getStatus() == HostRoleStatus.ABORTED && upgradeEntity.isSuspended()) {
            double percent = UpgradeResourceProvider.calculateAbortedProgress(summary);
            progressPercent = percent * 100.0;
        } else {
            progressPercent = calc.getPercent();
        }
        RequestEntity rentity = requestDAO.findByPK(upgradeEntity.getRequestId());
        UpgradeUpdateEvent upgradeUpdateEvent = new UpgradeUpdateEvent(UpdateEventType.UPDATE);
        upgradeUpdateEvent.setRequestId(upgradeEntity.getRequestId());
        upgradeUpdateEvent.setProgressPercent(progressPercent);
        upgradeUpdateEvent.setSuspended(upgradeEntity.isSuspended());
        upgradeUpdateEvent.setStartTime(rentity.getStartTime());
        upgradeUpdateEvent.setEndTime(rentity.getEndTime());
        upgradeUpdateEvent.setClusterId(upgradeEntity.getClusterId());
        upgradeUpdateEvent.setRequestStatus(calc.getStatus());
        return upgradeUpdateEvent;
    }

    public String getAssociatedVersion() {
        return this.associatedVersion;
    }

    public void setAssociatedVersion(String associatedVersion) {
        this.associatedVersion = associatedVersion;
    }

    public Long getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(Long clusterId) {
        this.clusterId = clusterId;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    public Boolean getDowngradeAllowed() {
        return this.downgradeAllowed;
    }

    public void setDowngradeAllowed(Boolean downgradeAllowed) {
        this.downgradeAllowed = downgradeAllowed;
    }

    public Long getRequestId() {
        return this.requestId;
    }

    public void setRequestId(Long requestId) {
        this.requestId = requestId;
    }

    public HostRoleStatus getRequestStatus() {
        return this.requestStatus;
    }

    public void setRequestStatus(HostRoleStatus requestStatus) {
        this.requestStatus = requestStatus;
    }

    public Boolean getSkipFailures() {
        return this.skipFailures;
    }

    public void setSkipFailures(Boolean skipFailures) {
        this.skipFailures = skipFailures;
    }

    public Boolean getSkipServiceCheckFailures() {
        return this.skipServiceCheckFailures;
    }

    public void setSkipServiceCheckFailures(Boolean skipServiceCheckFailures) {
        this.skipServiceCheckFailures = skipServiceCheckFailures;
    }

    public UpgradeType getUpgradeType() {
        return this.upgradeType;
    }

    public void setUpgradeType(UpgradeType upgradeType) {
        this.upgradeType = upgradeType;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Long endTime) {
        this.endTime = endTime;
    }

    public Long getUpgradeId() {
        return this.upgradeId;
    }

    public void setUpgradeId(Long upgradeId) {
        this.upgradeId = upgradeId;
    }

    public Boolean getSuspended() {
        return this.suspended;
    }

    public void setSuspended(Boolean suspended) {
        this.suspended = suspended;
    }

    public Double getProgressPercent() {
        return this.progressPercent;
    }

    public void setProgressPercent(Double progressPercent) {
        this.progressPercent = progressPercent;
    }

    public Boolean getRevertAllowed() {
        return this.revertAllowed;
    }

    public void setRevertAllowed(Boolean revertAllowed) {
        this.revertAllowed = revertAllowed;
    }
}

