/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.events;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import id.onyx.obdp.server.agent.stomp.dto.Hashable;
import id.onyx.obdp.server.agent.stomp.dto.TopologyCluster;
import id.onyx.obdp.server.events.STOMPEvent;
import id.onyx.obdp.server.events.UpdateEventType;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class TopologyUpdateEvent
extends STOMPEvent
implements Hashable {
    @JsonProperty(value="clusters")
    private final SortedMap<String, TopologyCluster> clusters;
    private String hash;
    private final UpdateEventType eventType;

    public TopologyUpdateEvent(SortedMap<String, TopologyCluster> clusters, UpdateEventType eventType) {
        this(STOMPEvent.Type.UI_TOPOLOGY, clusters, null, eventType);
    }

    public TopologyUpdateEvent(STOMPEvent.Type type, SortedMap<String, TopologyCluster> clusters, String hash, UpdateEventType eventType) {
        super(type);
        this.clusters = clusters;
        this.hash = hash;
        this.eventType = eventType;
    }

    public SortedMap<String, TopologyCluster> getClusters() {
        return this.clusters;
    }

    public TopologyUpdateEvent deepCopy() {
        TreeMap<String, TopologyCluster> copiedClusters = new TreeMap<String, TopologyCluster>();
        for (Map.Entry<String, TopologyCluster> topologyClusterEntry : this.getClusters().entrySet()) {
            copiedClusters.put(topologyClusterEntry.getKey(), topologyClusterEntry.getValue().deepCopyCluster());
        }
        TopologyUpdateEvent copiedEvent = new TopologyUpdateEvent(copiedClusters, this.getEventType());
        copiedEvent.setHash(this.getHash());
        return copiedEvent;
    }

    public UpdateEventType getEventType() {
        return this.eventType;
    }

    @Override
    public String getHash() {
        return this.hash;
    }

    @Override
    public void setHash(String hash) {
        this.hash = hash;
    }

    public static TopologyUpdateEvent emptyUpdate() {
        return new TopologyUpdateEvent(null, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopologyUpdateEvent that = (TopologyUpdateEvent)o;
        return Objects.equals((Object)this.eventType, (Object)that.eventType) && Objects.equals(this.clusters, that.clusters);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.clusters, this.eventType});
    }
}

