/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.events;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import id.onyx.obdp.server.actionmanager.HostRoleStatus;
import id.onyx.obdp.server.controller.internal.CalculatedStatus;
import id.onyx.obdp.server.events.STOMPEvent;
import id.onyx.obdp.server.orm.dao.HostRoleCommandDAO;
import id.onyx.obdp.server.orm.entities.HostRoleCommandEntity;
import id.onyx.obdp.server.orm.entities.RequestEntity;
import id.onyx.obdp.server.topology.TopologyManager;
import id.onyx.obdp.server.utils.StageUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class RequestUpdateEvent
extends STOMPEvent {
    private String clusterName;
    private Long endTime;
    private Long requestId;
    private Double progressPercent;
    private String requestContext;
    private HostRoleStatus requestStatus;
    private Long startTime;
    private String userName;
    @JsonProperty(value="Tasks")
    private Set<HostRoleCommand> hostRoleCommands = new HashSet<HostRoleCommand>();

    public RequestUpdateEvent(RequestEntity requestEntity, HostRoleCommandDAO hostRoleCommandDAO, TopologyManager topologyManager, String clusterName, List<HostRoleCommandEntity> hostRoleCommandEntities) {
        super(STOMPEvent.Type.REQUEST);
        this.clusterName = clusterName;
        this.endTime = requestEntity.getEndTime();
        this.requestId = requestEntity.getRequestId();
        this.progressPercent = CalculatedStatus.statusFromRequest(hostRoleCommandDAO, topologyManager, requestEntity.getRequestId()).getPercent();
        this.requestContext = requestEntity.getRequestContext();
        this.requestStatus = requestEntity.getStatus();
        this.startTime = requestEntity.getStartTime();
        this.userName = requestEntity.getUserName();
        for (HostRoleCommandEntity hostRoleCommandEntity : hostRoleCommandEntities) {
            this.hostRoleCommands.add(new HostRoleCommand(hostRoleCommandEntity.getTaskId(), hostRoleCommandEntity.getRequestId(), hostRoleCommandEntity.getStatus(), hostRoleCommandEntity.getHostName()));
        }
    }

    public RequestUpdateEvent(Long requestId, HostRoleStatus requestStatus, Set<HostRoleCommand> hostRoleCommands) {
        super(STOMPEvent.Type.REQUEST);
        this.requestId = requestId;
        this.requestStatus = requestStatus;
        this.hostRoleCommands = hostRoleCommands;
    }

    public Long getRequestId() {
        return this.requestId;
    }

    public void setRequestId(Long requestId) {
        this.requestId = requestId;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getRequestContext() {
        return this.requestContext;
    }

    public void setRequestContext(String requestContext) {
        this.requestContext = requestContext;
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Long endTime) {
        this.endTime = endTime;
    }

    public Double getProgressPercent() {
        return this.progressPercent;
    }

    public void setProgressPercent(Double progressPercent) {
        this.progressPercent = progressPercent;
    }

    public HostRoleStatus getRequestStatus() {
        return this.requestStatus;
    }

    public void setRequestStatus(HostRoleStatus requestStatus) {
        this.requestStatus = requestStatus;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public Set<HostRoleCommand> getHostRoleCommands() {
        return this.hostRoleCommands;
    }

    public void setHostRoleCommands(Set<HostRoleCommand> hostRoleCommands) {
        this.hostRoleCommands = hostRoleCommands;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestUpdateEvent that = (RequestUpdateEvent)o;
        if (this.clusterName != null ? !this.clusterName.equals(that.clusterName) : that.clusterName != null) {
            return false;
        }
        if (this.endTime != null ? !this.endTime.equals(that.endTime) : that.endTime != null) {
            return false;
        }
        if (this.requestId != null ? !this.requestId.equals(that.requestId) : that.requestId != null) {
            return false;
        }
        if (this.progressPercent != null ? !this.progressPercent.equals(that.progressPercent) : that.progressPercent != null) {
            return false;
        }
        if (this.requestContext != null ? !this.requestContext.equals(that.requestContext) : that.requestContext != null) {
            return false;
        }
        if (this.requestStatus != that.requestStatus) {
            return false;
        }
        if (this.startTime != null ? !this.startTime.equals(that.startTime) : that.startTime != null) {
            return false;
        }
        if (this.userName != null ? !this.userName.equals(that.userName) : that.userName != null) {
            return false;
        }
        return this.hostRoleCommands != null ? this.hostRoleCommands.equals(that.hostRoleCommands) : that.hostRoleCommands == null;
    }

    public int hashCode() {
        int result = this.clusterName != null ? this.clusterName.hashCode() : 0;
        result = 31 * result + (this.endTime != null ? this.endTime.hashCode() : 0);
        result = 31 * result + (this.requestId != null ? this.requestId.hashCode() : 0);
        result = 31 * result + (this.progressPercent != null ? this.progressPercent.hashCode() : 0);
        result = 31 * result + (this.requestContext != null ? this.requestContext.hashCode() : 0);
        result = 31 * result + (this.requestStatus != null ? this.requestStatus.hashCode() : 0);
        result = 31 * result + (this.startTime != null ? this.startTime.hashCode() : 0);
        result = 31 * result + (this.userName != null ? this.userName.hashCode() : 0);
        result = 31 * result + (this.hostRoleCommands != null ? this.hostRoleCommands.hashCode() : 0);
        return result;
    }

    public static class HostRoleCommand {
        private Long id;
        private Long requestId;
        private HostRoleStatus status;
        private String hostName;

        public HostRoleCommand(Long id, Long requestId, HostRoleStatus status, String hostName) {
            this.id = id;
            this.requestId = requestId;
            this.status = status;
            this.hostName = hostName == null ? StageUtils.getHostName() : hostName;
        }

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public Long getRequestId() {
            return this.requestId;
        }

        public void setRequestId(Long requestId) {
            this.requestId = requestId;
        }

        public HostRoleStatus getStatus() {
            return this.status;
        }

        public void setStatus(HostRoleStatus status) {
            this.status = status;
        }

        public String getHostName() {
            return this.hostName;
        }

        public void setHostName(String hostName) {
            this.hostName = hostName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HostRoleCommand that = (HostRoleCommand)o;
            if (!this.id.equals(that.id)) {
                return false;
            }
            if (!this.requestId.equals(that.requestId)) {
                return false;
            }
            return this.hostName != null ? this.hostName.equals(that.hostName) : that.hostName == null;
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = 31 * result + this.requestId.hashCode();
            result = 31 * result + (this.hostName != null ? this.hostName.hashCode() : 0);
            return result;
        }
    }
}

