/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.events;

import id.onyx.obdp.server.events.OBDPEvent;
import id.onyx.obdp.server.state.Host;
import id.onyx.obdp.server.state.MaintenanceState;
import id.onyx.obdp.server.state.Service;
import id.onyx.obdp.server.state.ServiceComponentHost;

public class MaintenanceModeEvent
extends OBDPEvent {
    private final MaintenanceState m_state;
    private final Service m_service;
    private final Host m_host;
    private final ServiceComponentHost m_serviceComponentHost;
    private final long m_clusterId;

    public MaintenanceModeEvent(MaintenanceState state, Service service) {
        this(state, service.getClusterId(), service, null, null);
    }

    public MaintenanceModeEvent(MaintenanceState state, long clusterId, Host host) {
        this(state, clusterId, null, host, null);
    }

    public MaintenanceModeEvent(MaintenanceState state, ServiceComponentHost serviceComponentHost) {
        this(state, serviceComponentHost.getClusterId(), null, null, serviceComponentHost);
    }

    private MaintenanceModeEvent(MaintenanceState state, long clusterId, Service service, Host host, ServiceComponentHost serviceComponentHost) {
        super(OBDPEvent.OBDPEventType.MAINTENANCE_MODE);
        this.m_state = state;
        this.m_clusterId = clusterId;
        this.m_service = service;
        this.m_host = host;
        this.m_serviceComponentHost = serviceComponentHost;
    }

    public Service getService() {
        return this.m_service;
    }

    public Host getHost() {
        return this.m_host;
    }

    public ServiceComponentHost getServiceComponentHost() {
        return this.m_serviceComponentHost;
    }

    public MaintenanceState getMaintenanceState() {
        return this.m_state;
    }

    public long getClusterId() {
        return this.m_clusterId;
    }

    @Override
    public String toString() {
        Object object = null;
        object = null != this.m_service ? this.m_service : (null != this.m_host ? this.m_host : this.m_serviceComponentHost);
        StringBuilder buffer = new StringBuilder("MaintenanceModeEvent{");
        buffer.append("state=").append((Object)this.m_state);
        buffer.append(", object=").append(object);
        buffer.append("}");
        return buffer.toString();
    }
}

