/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.events;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import id.onyx.obdp.server.events.STOMPEvent;
import id.onyx.obdp.server.orm.dao.AlertSummaryDTO;
import id.onyx.obdp.server.state.HostState;
import id.onyx.obdp.server.state.MaintenanceState;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class HostUpdateEvent
extends STOMPEvent {
    @JsonProperty(value="cluster_name")
    private String clusterName;
    @JsonProperty(value="host_name")
    private String hostName;
    @JsonProperty(value="host_status")
    private String hostStatus;
    @JsonProperty(value="host_state")
    private HostState hostState;
    @JsonProperty(value="last_heartbeat_time")
    private Long lastHeartbeatTime;
    @JsonProperty(value="maintenance_state")
    private MaintenanceState maintenanceState;
    @JsonProperty(value="alerts_summary")
    private AlertSummaryDTO alertsSummary;

    public HostUpdateEvent(String clusterName, String hostName, String hostStatus, HostState hostState, Long lastHeartbeatTime, MaintenanceState maintenanceState, AlertSummaryDTO alertsSummary) {
        super(STOMPEvent.Type.HOST);
        this.clusterName = clusterName;
        this.hostName = hostName;
        this.hostStatus = hostStatus;
        this.hostState = hostState;
        this.lastHeartbeatTime = lastHeartbeatTime;
        this.maintenanceState = maintenanceState;
        this.alertsSummary = alertsSummary;
    }

    public static HostUpdateEvent createHostStatusUpdate(String clusterName, String hostName, String hostStatus, Long lastHeartbeatTime) {
        return new HostUpdateEvent(clusterName, hostName, hostStatus, null, lastHeartbeatTime, null, null);
    }

    public static HostUpdateEvent createHostStateUpdate(String clusterName, String hostName, HostState hostState, Long lastHeartbeatTime) {
        return new HostUpdateEvent(clusterName, hostName, null, hostState, lastHeartbeatTime, null, null);
    }

    public static HostUpdateEvent createHostMaintenanceStatusUpdate(String clusterName, String hostName, MaintenanceState maintenanceState, AlertSummaryDTO alertsSummary) {
        return new HostUpdateEvent(clusterName, hostName, null, null, null, maintenanceState, alertsSummary);
    }

    public static HostUpdateEvent createHostAlertsUpdate(String clusterName, String hostName, AlertSummaryDTO alertsSummary) {
        return new HostUpdateEvent(clusterName, hostName, null, null, null, null, alertsSummary);
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getHostStatus() {
        return this.hostStatus;
    }

    public void setHostStatus(String hostStatus) {
        this.hostStatus = hostStatus;
    }

    public Long getLastHeartbeatTime() {
        return this.lastHeartbeatTime;
    }

    public void setLastHeartbeatTime(Long lastHeartbeatTime) {
        this.lastHeartbeatTime = lastHeartbeatTime;
    }

    public MaintenanceState getMaintenanceState() {
        return this.maintenanceState;
    }

    public void setMaintenanceState(MaintenanceState maintenanceState) {
        this.maintenanceState = maintenanceState;
    }

    public AlertSummaryDTO getAlertsSummary() {
        return this.alertsSummary;
    }

    public void setAlertsSummary(AlertSummaryDTO alertsSummary) {
        this.alertsSummary = alertsSummary;
    }

    public HostState getHostState() {
        return this.hostState;
    }

    public void setHostState(HostState hostState) {
        this.hostState = hostState;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostUpdateEvent that = (HostUpdateEvent)o;
        if (this.clusterName != null ? !this.clusterName.equals(that.clusterName) : that.clusterName != null) {
            return false;
        }
        if (this.hostName != null ? !this.hostName.equals(that.hostName) : that.hostName != null) {
            return false;
        }
        if (this.hostStatus != null ? !this.hostStatus.equals(that.hostStatus) : that.hostStatus != null) {
            return false;
        }
        if (this.hostState != that.hostState) {
            return false;
        }
        if (this.lastHeartbeatTime != null ? !this.lastHeartbeatTime.equals(that.lastHeartbeatTime) : that.lastHeartbeatTime != null) {
            return false;
        }
        if (this.maintenanceState != that.maintenanceState) {
            return false;
        }
        return this.alertsSummary != null ? this.alertsSummary.equals(that.alertsSummary) : that.alertsSummary == null;
    }

    public int hashCode() {
        int result = this.clusterName != null ? this.clusterName.hashCode() : 0;
        result = 31 * result + (this.hostName != null ? this.hostName.hashCode() : 0);
        result = 31 * result + (this.hostStatus != null ? this.hostStatus.hashCode() : 0);
        result = 31 * result + (this.hostState != null ? this.hostState.hashCode() : 0);
        result = 31 * result + (this.lastHeartbeatTime != null ? this.lastHeartbeatTime.hashCode() : 0);
        result = 31 * result + (this.maintenanceState != null ? this.maintenanceState.hashCode() : 0);
        result = 31 * result + (this.alertsSummary != null ? this.alertsSummary.hashCode() : 0);
        return result;
    }
}

