/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.events;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import id.onyx.obdp.server.agent.stomp.dto.Hashable;
import id.onyx.obdp.server.agent.stomp.dto.HostLevelParamsCluster;
import id.onyx.obdp.server.events.STOMPEvent;
import id.onyx.obdp.server.events.STOMPHostEvent;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class HostLevelParamsUpdateEvent
extends STOMPHostEvent
implements Hashable {
    private String hash;
    private final Long hostId;
    @JsonProperty(value="clusters")
    private final Map<String, HostLevelParamsCluster> hostLevelParamsClusters;

    public HostLevelParamsUpdateEvent(Long hostId, Map<String, HostLevelParamsCluster> hostLevelParamsClusters) {
        super(STOMPEvent.Type.HOSTLEVELPARAMS);
        this.hostId = hostId;
        this.hostLevelParamsClusters = hostLevelParamsClusters;
    }

    public HostLevelParamsUpdateEvent(Long hostId, String clusterId, HostLevelParamsCluster hostLevelParamsCluster) {
        this(hostId, Collections.singletonMap(clusterId, hostLevelParamsCluster));
    }

    @Override
    public String getHash() {
        return this.hash;
    }

    @Override
    public void setHash(String hash) {
        this.hash = hash;
    }

    public static HostLevelParamsUpdateEvent emptyUpdate() {
        return new HostLevelParamsUpdateEvent(null, null);
    }

    @Override
    public Long getHostId() {
        return this.hostId;
    }

    public Map<String, HostLevelParamsCluster> getHostLevelParamsClusters() {
        return this.hostLevelParamsClusters == null ? null : Collections.unmodifiableMap(this.hostLevelParamsClusters);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostLevelParamsUpdateEvent that = (HostLevelParamsUpdateEvent)o;
        return Objects.equals(this.hostId, that.hostId) && Objects.equals(this.hostLevelParamsClusters, that.hostLevelParamsClusters);
    }

    public int hashCode() {
        return Objects.hash(this.hostId, this.hostLevelParamsClusters);
    }
}

