/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.events;

import id.onyx.obdp.server.events.ClusterEvent;
import id.onyx.obdp.server.events.OBDPEvent;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.ServiceComponentHost;

public class HostComponentVersionAdvertisedEvent
extends ClusterEvent {
    protected Cluster cluster;
    protected ServiceComponentHost sch;
    protected String version;
    protected Long repoVersionId;

    public HostComponentVersionAdvertisedEvent(Cluster cluster, ServiceComponentHost sch, String version, Long repoVersionId) {
        this(cluster, sch, version);
        this.repoVersionId = repoVersionId;
    }

    public HostComponentVersionAdvertisedEvent(Cluster cluster, ServiceComponentHost sch, String version) {
        super(OBDPEvent.OBDPEventType.HOST_COMPONENT_VERSION_ADVERTISED, cluster.getClusterId());
        this.cluster = cluster;
        this.sch = sch;
        this.version = version;
    }

    public ServiceComponentHost getServiceComponentHost() {
        return this.sch;
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public String getVersion() {
        return this.version;
    }

    public Long getRepositoryVersionId() {
        return this.repoVersionId;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder("HostComponentVersionAdvertisedEvent{");
        buffer.append("cluserId=").append(this.m_clusterId);
        buffer.append(", serviceName=").append(this.sch.getServiceName());
        buffer.append(", componentName=").append(this.sch.getServiceComponentName());
        buffer.append(", hostName=").append(this.sch.getHostName());
        buffer.append(", version=").append(this.version);
        buffer.append(", repo_version_id=").append(this.repoVersionId);
        buffer.append("}");
        return buffer.toString();
    }
}

