/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.events;

import com.fasterxml.jackson.annotation.JsonInclude;
import id.onyx.obdp.server.orm.entities.HostComponentStateEntity;
import id.onyx.obdp.server.state.MaintenanceState;
import id.onyx.obdp.server.state.State;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class HostComponentUpdate {
    private Long clusterId;
    private String serviceName;
    private String hostName;
    private String componentName;
    private State currentState;
    private State previousState;
    private MaintenanceState maintenanceState;
    private Boolean staleConfigs;

    private HostComponentUpdate(Long clusterId, String serviceName, String hostName, String componentName, State currentState, State previousState, MaintenanceState maintenanceState, Boolean staleConfigs) {
        this.clusterId = clusterId;
        this.serviceName = serviceName;
        this.hostName = hostName;
        this.componentName = componentName;
        this.currentState = currentState;
        this.previousState = previousState;
        this.maintenanceState = maintenanceState;
        this.staleConfigs = staleConfigs;
    }

    public static HostComponentUpdate createHostComponentStatusUpdate(HostComponentStateEntity stateEntity, State previousState) {
        HostComponentUpdate hostComponentUpdate = new HostComponentUpdate(stateEntity.getClusterId(), stateEntity.getServiceName(), stateEntity.getHostEntity().getHostName(), stateEntity.getComponentName(), stateEntity.getCurrentState(), previousState, null, null);
        return hostComponentUpdate;
    }

    public static HostComponentUpdate createHostComponentMaintenanceStatusUpdate(Long clusterId, String serviceName, String hostName, String componentName, MaintenanceState maintenanceState) {
        HostComponentUpdate hostComponentUpdate = new HostComponentUpdate(clusterId, serviceName, hostName, componentName, null, null, maintenanceState, null);
        return hostComponentUpdate;
    }

    public static HostComponentUpdate createHostComponentStaleConfigsStatusUpdate(Long clusterId, String serviceName, String hostName, String componentName, Boolean isStaleConfig) {
        HostComponentUpdate hostComponentUpdate = new HostComponentUpdate(clusterId, serviceName, hostName, componentName, null, null, null, isStaleConfig);
        return hostComponentUpdate;
    }

    public Long getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(Long clusterId) {
        this.clusterId = clusterId;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public State getCurrentState() {
        return this.currentState;
    }

    public void setCurrentState(State currentState) {
        this.currentState = currentState;
    }

    public State getPreviousState() {
        return this.previousState;
    }

    public void setPreviousState(State previousState) {
        this.previousState = previousState;
    }

    public MaintenanceState getMaintenanceState() {
        return this.maintenanceState;
    }

    public void setMaintenanceState(MaintenanceState maintenanceState) {
        this.maintenanceState = maintenanceState;
    }

    public Boolean getStaleConfigs() {
        return this.staleConfigs;
    }

    public void setStaleConfigs(Boolean staleConfigs) {
        this.staleConfigs = staleConfigs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostComponentUpdate that = (HostComponentUpdate)o;
        if (this.clusterId != null ? !this.clusterId.equals(that.clusterId) : that.clusterId != null) {
            return false;
        }
        if (this.serviceName != null ? !this.serviceName.equals(that.serviceName) : that.serviceName != null) {
            return false;
        }
        if (this.hostName != null ? !this.hostName.equals(that.hostName) : that.hostName != null) {
            return false;
        }
        if (this.componentName != null ? !this.componentName.equals(that.componentName) : that.componentName != null) {
            return false;
        }
        if (this.currentState != that.currentState) {
            return false;
        }
        if (this.previousState != that.previousState) {
            return false;
        }
        if (this.maintenanceState != that.maintenanceState) {
            return false;
        }
        return this.staleConfigs != null ? this.staleConfigs.equals(that.staleConfigs) : that.staleConfigs == null;
    }

    public int hashCode() {
        int result = this.clusterId != null ? this.clusterId.hashCode() : 0;
        result = 31 * result + (this.serviceName != null ? this.serviceName.hashCode() : 0);
        result = 31 * result + (this.hostName != null ? this.hostName.hashCode() : 0);
        result = 31 * result + (this.componentName != null ? this.componentName.hashCode() : 0);
        result = 31 * result + (this.currentState != null ? this.currentState.hashCode() : 0);
        result = 31 * result + (this.previousState != null ? this.previousState.hashCode() : 0);
        result = 31 * result + (this.maintenanceState != null ? this.maintenanceState.hashCode() : 0);
        result = 31 * result + (this.staleConfigs != null ? this.staleConfigs.hashCode() : 0);
        return result;
    }
}

