/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.events;

import id.onyx.obdp.server.MessageDestinationIsNotDefinedException;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.agent.AgentSessionManager;
import id.onyx.obdp.server.events.ExecutionCommandEvent;
import id.onyx.obdp.server.events.MessageEmitter;
import id.onyx.obdp.server.events.STOMPEvent;
import id.onyx.obdp.server.events.STOMPHostEvent;
import id.onyx.obdp.server.events.publishers.OBDPEventPublisher;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.messaging.simp.SimpMessagingTemplate;

public class DefaultMessageEmitter
extends MessageEmitter {
    private final Map<STOMPEvent.Type, String> DEFAULT_DESTINATIONS = Collections.unmodifiableMap(new HashMap<STOMPEvent.Type, String>(){
        {
            this.put(STOMPEvent.Type.ALERT, "/events/alerts");
            this.put(STOMPEvent.Type.ALERT_GROUP, "/events/alert_group");
            this.put(STOMPEvent.Type.METADATA, "/events/metadata");
            this.put(STOMPEvent.Type.HOSTLEVELPARAMS, "/host_level_params");
            this.put(STOMPEvent.Type.UI_TOPOLOGY, "/events/ui_topologies");
            this.put(STOMPEvent.Type.AGENT_TOPOLOGY, "/events/topologies");
            this.put(STOMPEvent.Type.AGENT_CONFIGS, "/configs");
            this.put(STOMPEvent.Type.CONFIGS, "/events/configs");
            this.put(STOMPEvent.Type.HOSTCOMPONENT, "/events/hostcomponents");
            this.put(STOMPEvent.Type.NAMEDTASK, "/events/tasks");
            this.put(STOMPEvent.Type.REQUEST, "/events/requests");
            this.put(STOMPEvent.Type.SERVICE, "/events/services");
            this.put(STOMPEvent.Type.HOST, "/events/hosts");
            this.put(STOMPEvent.Type.COMMAND, "/commands");
            this.put(STOMPEvent.Type.ALERT_DEFINITIONS, "/alert_definitions");
            this.put(STOMPEvent.Type.UI_ALERT_DEFINITIONS, "/events/alert_definitions");
            this.put(STOMPEvent.Type.UPGRADE, "/events/upgrade");
            this.put(STOMPEvent.Type.AGENT_ACTIONS, "/agent_actions");
            this.put(STOMPEvent.Type.ENCRYPTION_KEY_UPDATE, "/events/encryption_key");
        }
    });
    public static final Set<STOMPEvent.Type> DEFAULT_AGENT_EVENT_TYPES = Collections.unmodifiableSet(new HashSet<STOMPEvent.Type>(Arrays.asList(STOMPEvent.Type.METADATA, STOMPEvent.Type.HOSTLEVELPARAMS, STOMPEvent.Type.AGENT_TOPOLOGY, STOMPEvent.Type.AGENT_CONFIGS, STOMPEvent.Type.COMMAND, STOMPEvent.Type.ALERT_DEFINITIONS, STOMPEvent.Type.AGENT_ACTIONS, STOMPEvent.Type.ENCRYPTION_KEY_UPDATE)));
    public static final Set<STOMPEvent.Type> DEFAULT_API_EVENT_TYPES = Collections.unmodifiableSet(new HashSet<STOMPEvent.Type>(Arrays.asList(STOMPEvent.Type.ALERT, STOMPEvent.Type.ALERT_GROUP, STOMPEvent.Type.METADATA, STOMPEvent.Type.UI_TOPOLOGY, STOMPEvent.Type.CONFIGS, STOMPEvent.Type.HOSTCOMPONENT, STOMPEvent.Type.NAMEDTASK, STOMPEvent.Type.REQUEST, STOMPEvent.Type.SERVICE, STOMPEvent.Type.HOST, STOMPEvent.Type.UI_ALERT_DEFINITIONS, STOMPEvent.Type.UPGRADE)));

    public DefaultMessageEmitter(AgentSessionManager agentSessionManager, SimpMessagingTemplate simpMessagingTemplate, OBDPEventPublisher ambariEventPublisher, int retryCount, int retryInterval) {
        super(agentSessionManager, simpMessagingTemplate, ambariEventPublisher, retryCount, retryInterval);
    }

    @Override
    public void emitMessage(STOMPEvent event) throws OBDPException {
        if (StringUtils.isEmpty((String)this.getDestination(event))) {
            throw new MessageDestinationIsNotDefinedException(event.getType());
        }
        if (event instanceof STOMPHostEvent) {
            STOMPHostEvent hostUpdateEvent = (STOMPHostEvent)event;
            if (hostUpdateEvent.getType().equals((Object)STOMPEvent.Type.COMMAND)) {
                this.emitMessageRetriable((ExecutionCommandEvent)hostUpdateEvent);
            } else {
                this.emitMessageToHost(hostUpdateEvent);
            }
        } else {
            this.emitMessageToAll(event);
        }
    }

    @Override
    protected String getDestination(STOMPEvent stompEvent) {
        return stompEvent.completeDestination(this.DEFAULT_DESTINATIONS.get((Object)stompEvent.getType()));
    }
}

