/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.events;

import com.fasterxml.jackson.annotation.JsonInclude;
import id.onyx.obdp.server.events.STOMPEvent;
import id.onyx.obdp.server.orm.entities.ClusterConfigEntity;
import id.onyx.obdp.server.orm.entities.ServiceConfigEntity;
import id.onyx.obdp.server.state.Cluster;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class ConfigsUpdateEvent
extends STOMPEvent {
    private Long serviceConfigId;
    private Long clusterId;
    private String serviceName;
    private Long groupId;
    private Long version;
    private String user;
    private String note;
    private List<String> hostNames;
    private Long createTime;
    private String groupName;
    private List<ClusterConfig> configs = new ArrayList<ClusterConfig>();
    private Set<String> changedConfigTypes = new HashSet<String>();

    public ConfigsUpdateEvent(ServiceConfigEntity configs, String configGroupName, List<String> hostNames, Set<String> changedConfigTypes) {
        super(STOMPEvent.Type.CONFIGS);
        this.serviceConfigId = configs.getServiceConfigId();
        this.clusterId = configs.getClusterEntity().getClusterId();
        this.serviceName = configs.getServiceName();
        this.groupId = configs.getGroupId();
        this.version = configs.getVersion();
        this.user = configs.getUser();
        this.note = configs.getNote();
        this.hostNames = hostNames == null ? null : new ArrayList<String>(hostNames);
        for (ClusterConfigEntity clusterConfigEntity : configs.getClusterConfigEntities()) {
            this.configs.add(new ClusterConfig(clusterConfigEntity.getClusterId(), clusterConfigEntity.getType(), clusterConfigEntity.getTag(), clusterConfigEntity.getVersion()));
        }
        this.createTime = configs.getCreateTimestamp();
        this.groupName = configGroupName;
        this.changedConfigTypes = changedConfigTypes;
    }

    public ConfigsUpdateEvent(Cluster cluster, Collection<ClusterConfigEntity> configs) {
        super(STOMPEvent.Type.CONFIGS);
        this.clusterId = cluster.getClusterId();
        for (ClusterConfigEntity clusterConfigEntity : configs) {
            this.configs.add(new ClusterConfig(clusterConfigEntity.getClusterId(), clusterConfigEntity.getType(), clusterConfigEntity.getTag(), clusterConfigEntity.getVersion()));
        }
    }

    public Long getServiceConfigId() {
        return this.serviceConfigId;
    }

    public void setServiceConfigId(Long serviceConfigId) {
        this.serviceConfigId = serviceConfigId;
    }

    public Long getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(Long clusterId) {
        this.clusterId = clusterId;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public Long getGroupId() {
        return this.groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public Long getVersion() {
        return this.version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public List<String> getHostNames() {
        return this.hostNames;
    }

    public void setHostNames(List<String> hostNames) {
        this.hostNames = hostNames;
    }

    public List<ClusterConfig> getConfigs() {
        return this.configs;
    }

    public void setConfigs(List<ClusterConfig> configs) {
        this.configs = configs;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public Set<String> getChangedConfigTypes() {
        return this.changedConfigTypes;
    }

    public void setChangedConfigTypes(Set<String> changedConfigTypes) {
        this.changedConfigTypes = changedConfigTypes;
    }

    public class ClusterConfig {
        private Long clusterId;
        private String type;
        private String tag;
        private Long version;

        public ClusterConfig(Long clusterId, String type, String tag, Long version) {
            this.clusterId = clusterId;
            this.type = type;
            this.tag = tag;
            this.version = version;
        }

        public Long getClusterId() {
            return this.clusterId;
        }

        public void setClusterId(Long clusterId) {
            this.clusterId = clusterId;
        }

        public String getTag() {
            return this.tag;
        }

        public void setTag(String tag) {
            this.tag = tag;
        }

        public Long getVersion() {
            return this.version;
        }

        public void setVersion(Long version) {
            this.version = version;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClusterConfig that = (ClusterConfig)o;
            if (this.clusterId != null ? !this.clusterId.equals(that.clusterId) : that.clusterId != null) {
                return false;
            }
            if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
                return false;
            }
            if (this.tag != null ? !this.tag.equals(that.tag) : that.tag != null) {
                return false;
            }
            return this.version != null ? this.version.equals(that.version) : that.version == null;
        }

        public int hashCode() {
            int result = this.clusterId != null ? this.clusterId.hashCode() : 0;
            result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
            result = 31 * result + (this.tag != null ? this.tag.hashCode() : 0);
            result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
            return result;
        }
    }
}

