/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.events;

import id.onyx.obdp.server.events.AlertEvent;
import id.onyx.obdp.server.orm.entities.AlertCurrentEntity;
import id.onyx.obdp.server.orm.entities.AlertHistoryEntity;
import id.onyx.obdp.server.state.Alert;
import id.onyx.obdp.server.state.AlertFirmness;
import id.onyx.obdp.server.state.AlertState;

public class AlertStateChangeEvent
extends AlertEvent {
    private final AlertState m_fromState;
    private final AlertFirmness m_fromFirmness;
    private final AlertCurrentEntity m_currentAlert;
    private final AlertHistoryEntity m_history;

    public AlertStateChangeEvent(long clusterId, Alert alert, AlertCurrentEntity currentAlert, AlertState fromState, AlertFirmness fromFirmness) {
        super(clusterId, alert);
        this.m_currentAlert = currentAlert;
        this.m_history = currentAlert.getAlertHistory();
        this.m_fromState = fromState;
        this.m_fromFirmness = fromFirmness;
    }

    public AlertCurrentEntity getCurrentAlert() {
        return this.m_currentAlert;
    }

    public AlertHistoryEntity getNewHistoricalEntry() {
        return this.m_history;
    }

    public AlertState getFromState() {
        return this.m_fromState;
    }

    public AlertFirmness getFromFirmness() {
        return this.m_fromFirmness;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("AlertStateChangeEvent{");
        buffer.append("cluserId=").append(this.m_clusterId);
        buffer.append(", fromState=").append((Object)this.m_fromState);
        buffer.append(", firmness=").append((Object)this.m_currentAlert.getFirmness());
        buffer.append(", alert=").append(this.m_alert);
        buffer.append("}");
        return buffer.toString();
    }
}

