/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.events;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import id.onyx.obdp.server.agent.stomp.dto.ClusterConfigs;
import id.onyx.obdp.server.agent.stomp.dto.Hashable;
import id.onyx.obdp.server.events.STOMPEvent;
import id.onyx.obdp.server.events.STOMPHostEvent;
import java.util.Objects;
import java.util.SortedMap;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AgentConfigsUpdateEvent
extends STOMPHostEvent
implements Hashable {
    private String hash;
    private Long timestamp;
    private final Long hostId;
    @JsonProperty(value="clusters")
    private final SortedMap<String, ClusterConfigs> clustersConfigs;

    public AgentConfigsUpdateEvent(Long hostId, SortedMap<String, ClusterConfigs> clustersConfigs) {
        super(STOMPEvent.Type.AGENT_CONFIGS);
        this.hostId = hostId;
        this.clustersConfigs = clustersConfigs;
        this.timestamp = System.currentTimeMillis();
    }

    @Override
    public String getHash() {
        return this.hash;
    }

    @Override
    public void setHash(String hash) {
        this.hash = hash;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public Long getHostId() {
        return this.hostId;
    }

    public SortedMap<String, ClusterConfigs> getClustersConfigs() {
        return this.clustersConfigs;
    }

    public static AgentConfigsUpdateEvent emptyUpdate() {
        return new AgentConfigsUpdateEvent(null, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AgentConfigsUpdateEvent that = (AgentConfigsUpdateEvent)o;
        return Objects.equals(this.hostId, that.hostId) && Objects.equals(this.clustersConfigs, that.clustersConfigs);
    }

    public int hashCode() {
        return Objects.hash(this.hostId, this.clustersConfigs);
    }
}

