/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.customactions;

import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.actionmanager.ActionType;
import id.onyx.obdp.server.actionmanager.TargetHostType;
import id.onyx.obdp.server.customactions.ActionDefinition;
import id.onyx.obdp.server.customactions.ActionDefinitionSpec;
import id.onyx.obdp.server.customactions.ActionDefinitionXml;
import id.onyx.obdp.server.security.authorization.RoleAuthorization;
import id.onyx.obdp.server.stack.StackDirectory;
import java.io.File;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionDefinitionManager {
    public static final Integer MIN_TIMEOUT = 60;
    private static final Logger LOG = LoggerFactory.getLogger(ActionDefinitionManager.class);
    private static final Map<Class<?>, JAXBContext> _jaxbContexts = new HashMap();
    private static final Integer MAX_TIMEOUT = 0x7FFFFFFE;
    private final Map<String, ActionDefinition> actionDefinitionMap = new HashMap<String, ActionDefinition>();

    public static <T> T unmarshal(Class<T> clz, File file) throws JAXBException {
        Unmarshaller u = _jaxbContexts.get(clz).createUnmarshaller();
        return clz.cast(u.unmarshal(file));
    }

    private <E extends Enum<E>> E safeValueOf(Class<E> enumm, String s, StringBuilder reason) {
        if (s == null || s.length() == 0) {
            return null;
        }
        try {
            return Enum.valueOf(enumm, s);
        }
        catch (IllegalArgumentException iaex) {
            reason.append("Invalid value provided for ").append(enumm.getName());
            return null;
        }
    }

    public void readCustomActionDefinitions(File customActionDefinitionRoot) throws JAXBException, OBDPException {
        File[] customActionDefinitionFiles;
        if (customActionDefinitionRoot == null || !customActionDefinitionRoot.exists() || !customActionDefinitionRoot.canRead()) {
            LOG.warn("Cannot read custom action definitions. " + (String)(customActionDefinitionRoot == null ? "" : "Check path " + customActionDefinitionRoot.getAbsolutePath()));
        }
        if ((customActionDefinitionFiles = customActionDefinitionRoot.listFiles(StackDirectory.FILENAME_FILTER)) != null) {
            for (File definitionFile : customActionDefinitionFiles) {
                ActionDefinitionXml adx = null;
                try {
                    adx = ActionDefinitionManager.unmarshal(ActionDefinitionXml.class, definitionFile);
                }
                catch (UnmarshalException uex) {
                    LOG.warn("Encountered badly formed action definition file - " + definitionFile.getAbsolutePath());
                    continue;
                }
                for (ActionDefinitionSpec ad : adx.actionDefinitions()) {
                    LOG.debug("Read action definition = {}", (Object)ad);
                    StringBuilder errorReason = new StringBuilder("Error while parsing action definition. ").append(ad).append(" --- ");
                    TargetHostType targetType = this.safeValueOf(TargetHostType.class, ad.getTargetType(), errorReason);
                    ActionType actionType = this.safeValueOf(ActionType.class, ad.getActionType(), errorReason);
                    Integer defaultTimeout = MIN_TIMEOUT;
                    if (ad.getDefaultTimeout() != null && !ad.getDefaultTimeout().isEmpty()) {
                        defaultTimeout = Integer.parseInt(ad.getDefaultTimeout());
                    }
                    if (this.isValidActionDefinition(ad, actionType, defaultTimeout, errorReason)) {
                        String actionName = ad.getActionName();
                        if (this.actionDefinitionMap.containsKey(actionName)) {
                            LOG.warn("Ignoring action definition as a different definition by that name already exists. " + ad);
                            continue;
                        }
                        this.actionDefinitionMap.put(ad.getActionName(), new ActionDefinition(ad.getActionName(), actionType, ad.getInputs(), ad.getTargetService(), ad.getTargetComponent(), ad.getDescription(), targetType, defaultTimeout, this.translatePermissions(ad.getPermissions())));
                        LOG.info("Added custom action definition for " + ad.getActionName());
                        continue;
                    }
                    LOG.warn(errorReason.toString());
                }
            }
        }
    }

    private boolean isValidActionDefinition(ActionDefinitionSpec ad, ActionType actionType, Integer defaultTimeout, StringBuilder reason) {
        if (this.isValidActionName(ad.getActionName(), reason)) {
            if (defaultTimeout < MIN_TIMEOUT || defaultTimeout > MAX_TIMEOUT) {
                reason.append("Default timeout should be between " + MIN_TIMEOUT + " and " + MAX_TIMEOUT);
                return false;
            }
            if (actionType == null || actionType == ActionType.SYSTEM_DISABLED) {
                reason.append("Action type cannot be ").append((Object)actionType);
                return false;
            }
            if (ad.getDescription() == null || ad.getDescription().isEmpty()) {
                reason.append("Action description cannot be empty");
                return false;
            }
            if ((ad.getTargetService() == null || ad.getTargetService().isEmpty()) && ad.getTargetComponent() != null && !ad.getTargetComponent().isEmpty()) {
                reason.append("Target component cannot be specified unless target service is specified");
                return false;
            }
            if (ad.getInputs() != null && !ad.getInputs().isEmpty()) {
                String[] parameters;
                for (String parameter : parameters = ad.getInputs().split(",")) {
                    if (!parameter.trim().isEmpty()) continue;
                    reason.append("Empty parameter cannot be specified as an input parameter");
                }
            }
        } else {
            return false;
        }
        return true;
    }

    public List<ActionDefinition> getAllActionDefinition() {
        return new ArrayList<ActionDefinition>(this.actionDefinitionMap.values());
    }

    public ActionDefinition getActionDefinition(String name) {
        return this.actionDefinitionMap.get(name);
    }

    public void addActionDefinition(ActionDefinition ad) throws OBDPException {
        if (this.actionDefinitionMap.containsKey(ad.getActionName())) {
            throw new OBDPException("Action definition by name " + ad.getActionName() + " already exists.");
        }
        this.actionDefinitionMap.put(ad.getActionName(), ad);
    }

    private boolean isValidActionName(String actionName, StringBuilder reason) {
        if (actionName == null || actionName.isEmpty()) {
            reason.append("Action name cannot be empty");
            return false;
        }
        String trimmedName = actionName.replaceAll("\\s+", "");
        if (actionName.length() > trimmedName.length()) {
            reason.append("Action name cannot contain white spaces");
            return false;
        }
        return true;
    }

    private Set<RoleAuthorization> translatePermissions(String permissions) {
        String[] parts;
        if (StringUtils.isEmpty((String)permissions)) {
            return null;
        }
        HashSet<RoleAuthorization> authorizations = new HashSet<RoleAuthorization>();
        for (String permission : parts = permissions.split(",")) {
            RoleAuthorization authorization = RoleAuthorization.translate(permission);
            if (authorization == null) continue;
            authorizations.add(authorization);
        }
        return authorizations.isEmpty() ? null : EnumSet.copyOf(authorizations);
    }

    static {
        try {
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{ActionDefinitionXml.class});
            _jaxbContexts.put(ActionDefinitionXml.class, ctx);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }
}

