/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.credentialapi;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.security.alias.CredentialProvider;
import org.apache.hadoop.security.alias.CredentialProviderFactory;
import org.apache.hadoop.security.alias.CredentialShell;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class CredentialUtil
extends Configured
implements Tool {
    private static final String COMMANDS = "   [--help]\n   [create <alias> [-value credential] [-provider provider-path] [-f | -n]]\n   [delete <alias> [-f] [-provider provider-path]]\n   [list [-provider provider-path]]\n   [get <alias> [-provider provider-path]]\n";
    public static final String jceksPrefix = "jceks://file";
    public static final String localJceksPrefix = "localjceks://file";
    private String alias = null;
    private String value = null;
    protected CredentialProvider provider;
    private boolean overwrite = true;
    private boolean interactive = true;
    private Command command = null;

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new Configuration(), (Tool)new CredentialUtil(), (String[])args);
        System.exit(res);
    }

    public int run(String[] args) throws Exception {
        int exitCode = 1;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("create")) {
                if (i == args.length - 1) {
                    return 1;
                }
                this.command = new CreateCommand();
                this.alias = args[++i];
                if (!this.alias.equals("-h") && !this.alias.equals("-help")) continue;
                this.printUsage();
                return 0;
            }
            if (args[i].equals("get")) {
                if (i == args.length - 1) {
                    return 1;
                }
                this.command = new GetCommand();
                this.alias = args[++i];
                if (!this.alias.equals("-h") && !this.alias.equals("-help")) continue;
                this.printUsage();
                return 0;
            }
            if (args[i].equals("delete")) {
                if (i == args.length - 1) {
                    this.printUsage();
                    return 1;
                }
                this.command = new DeleteCommand();
                this.alias = args[++i];
                if (!this.alias.equals("-help")) continue;
                this.printUsage();
                return 0;
            }
            if (args[i].equals("list")) {
                if (i < args.length - 1) {
                    this.alias = args[i + 1];
                }
                this.command = new ListCommand();
                if (this.alias.equals("-h") || this.alias.equals("-help")) {
                    this.printUsage();
                    return 0;
                }
                this.alias = "not required";
                continue;
            }
            if (args[i].equals("-provider")) {
                if (i == args.length - 1) {
                    return 1;
                }
                String providerPath = CredentialUtil.getNormalizedPath(args[++i]);
                this.getConf().set("hadoop.security.credential.provider.path", providerPath);
                this.provider = this.getCredentialProvider();
                continue;
            }
            if (args[i].equals("-f") || args[i].equals("-force")) {
                this.interactive = false;
                this.overwrite = true;
                continue;
            }
            if (args[i].equals("-n")) {
                this.interactive = false;
                this.overwrite = false;
                continue;
            }
            if (args[i].equals("-v") || args[i].equals("-value")) {
                this.value = args[++i];
                continue;
            }
            if (args[i].equals("-h") || args[i].equals("-help")) {
                this.printUsage();
                return 0;
            }
            this.printUsage();
            ToolRunner.printGenericCommandUsage((PrintStream)System.err);
            return 1;
        }
        if (this.command == null) {
            this.printUsage();
        } else if (this.command.validate()) {
            exitCode = this.command.execute();
        }
        return exitCode;
    }

    protected void printUsage() {
        System.out.println(this.getUsagePrefix() + COMMANDS);
        if (this.command != null) {
            System.out.println(this.command.getUsage());
        } else {
            System.out.println("===============================================================");
            System.out.println("create <alias> [-value credential] [-provider provider-path] [-f | -n]:\n\nThe create subcommand creates a new credential or overwrites\nan existing credential for the name specified\nas the <alias> argument within the provider indicated through\nthe -provider argument. The command asks for confirmation to\noverwrite the existing credential unless the -f option is specified.\nSpecify -n to not overwrite if the credential exists.\nThe option specified last wins.");
            System.out.println("===============================================================");
            System.out.println("delete <alias> [-f] [-provider provider-path]:\n\nThe delete subcommand deletes the credential specified\nas the <alias> argument from within the provider indicated\nthrough the -provider argument. The command asks for\nconfirmation unless the -f option is specified.");
            System.out.println("===============================================================");
            System.out.println("list [-provider provider-path]:\n\nThe list subcommand displays the aliases contained within \na particular provider - as configured in core-site.xml or\n indicated through the -provider argument.");
            System.out.println("===============================================================");
            System.out.println("get <alias> [-provider provider-path]:\n\nThe get subcommand gets the credential for the specified alias\nfrom the provider specified through the -provider argument.\n");
        }
    }

    protected String getUsagePrefix() {
        return "Usage: ";
    }

    private static String getNormalizedPath(String providerPath) {
        if (providerPath != null) {
            String jceksPath;
            if (((String)providerPath).startsWith("/")) {
                providerPath = ((String)providerPath).substring(1);
            }
            if (!(jceksPath = StringUtils.lowerCase((String)((String)providerPath).trim())).startsWith(StringUtils.lowerCase((String)jceksPrefix)) && !jceksPath.startsWith(localJceksPrefix)) {
                providerPath = "jceks://file/" + (String)providerPath;
            }
        }
        return providerPath;
    }

    private CredentialProvider getCredentialProvider() {
        CredentialProvider provider = null;
        try {
            List providers = CredentialProviderFactory.getProviders((Configuration)this.getConf());
            provider = (CredentialProvider)providers.get(0);
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
        return provider;
    }

    private class CreateCommand
    extends Command {
        public static final String USAGE = "create <alias> [-value credential] [-provider provider-path] [-f | -n]";
        public static final String DESC = "The create subcommand creates a new credential or overwrites\nan existing credential for the name specified\nas the <alias> argument within the provider indicated through\nthe -provider argument. The command asks for confirmation to\noverwrite the existing credential unless the -f option is specified.\nSpecify -n to not overwrite if the credential exists.\nThe option specified last wins.";

        private CreateCommand() {
        }

        @Override
        public int execute() throws Exception {
            int exitCode = 0;
            CredentialProvider.CredentialEntry credEntry = CredentialUtil.this.provider.getCredentialEntry(CredentialUtil.this.alias);
            if (credEntry != null) {
                if (CredentialUtil.this.interactive) {
                    CredentialUtil.this.overwrite = ToolRunner.confirmPrompt((String)("You are about to OVERWRITE the credential " + CredentialUtil.this.alias + " from CredentialProvider " + CredentialUtil.this.provider + ". Continue? "));
                }
                if (CredentialUtil.this.overwrite) {
                    DeleteCommand deleteCommand = new DeleteCommand();
                    exitCode = deleteCommand.execute();
                } else {
                    return 0;
                }
            }
            if (exitCode == 0) {
                exitCode = this.createCredential();
            }
            return exitCode;
        }

        @Override
        public String getUsage() {
            return "create <alias> [-value credential] [-provider provider-path] [-f | -n]:\n\nThe create subcommand creates a new credential or overwrites\nan existing credential for the name specified\nas the <alias> argument within the provider indicated through\nthe -provider argument. The command asks for confirmation to\noverwrite the existing credential unless the -f option is specified.\nSpecify -n to not overwrite if the credential exists.\nThe option specified last wins.";
        }

        private int createCredential() throws Exception {
            ArrayList<String> args = new ArrayList<String>();
            args.add("create");
            args.add(CredentialUtil.this.alias);
            if (CredentialUtil.this.value != null) {
                args.add("-value");
                args.add(CredentialUtil.this.value);
            }
            String[] toolArgs = args.toArray(new String[args.size()]);
            int exitCode = ToolRunner.run((Configuration)CredentialUtil.this.getConf(), (Tool)new CredentialShell(), (String[])toolArgs);
            return exitCode;
        }
    }

    private class DeleteCommand
    extends Command {
        public static final String USAGE = "delete <alias> [-f] [-provider provider-path]";
        public static final String DESC = "The delete subcommand deletes the credential specified\nas the <alias> argument from within the provider indicated\nthrough the -provider argument. The command asks for\nconfirmation unless the -f option is specified.";

        private DeleteCommand() {
        }

        @Override
        public int execute() throws Exception {
            ArrayList<String> args = new ArrayList<String>();
            args.add("delete");
            args.add(CredentialUtil.this.alias);
            if (!CredentialUtil.this.interactive) {
                args.add("-f");
            }
            String[] toolArgs = args.toArray(new String[args.size()]);
            int exitCode = ToolRunner.run((Configuration)CredentialUtil.this.getConf(), (Tool)new CredentialShell(), (String[])toolArgs);
            return exitCode;
        }

        @Override
        public String getUsage() {
            return "delete <alias> [-f] [-provider provider-path]:\n\nThe delete subcommand deletes the credential specified\nas the <alias> argument from within the provider indicated\nthrough the -provider argument. The command asks for\nconfirmation unless the -f option is specified.";
        }
    }

    private class ListCommand
    extends Command {
        public static final String USAGE = "list [-provider provider-path]";
        public static final String DESC = "The list subcommand displays the aliases contained within \na particular provider - as configured in core-site.xml or\n indicated through the -provider argument.";

        private ListCommand() {
        }

        @Override
        public int execute() throws Exception {
            ArrayList<String> args = new ArrayList<String>();
            args.add("list");
            String[] toolArgs = args.toArray(new String[args.size()]);
            int exitCode = ToolRunner.run((Configuration)CredentialUtil.this.getConf(), (Tool)new CredentialShell(), (String[])toolArgs);
            return exitCode;
        }

        @Override
        public String getUsage() {
            return "list [-provider provider-path]:\n\nThe list subcommand displays the aliases contained within \na particular provider - as configured in core-site.xml or\n indicated through the -provider argument.";
        }
    }

    private class GetCommand
    extends Command {
        public static final String USAGE = "get <alias> [-provider provider-path]";
        public static final String DESC = "The get subcommand gets the credential for the specified alias\nfrom the provider specified through the -provider argument.\n";

        private GetCommand() {
        }

        @Override
        public int execute() throws IOException {
            int exitCode = 0;
            try {
                String credential = this.getCredential();
                if (credential == null) {
                    exitCode = 1;
                } else {
                    System.out.println(credential);
                }
            }
            catch (IOException ex) {
                System.out.println("Cannot get the credential for the specified alias.: " + ex.getMessage());
                throw ex;
            }
            return exitCode;
        }

        private String getCredential() throws IOException {
            char[] password;
            String credential = null;
            CredentialProvider.CredentialEntry credEntry = CredentialUtil.this.provider.getCredentialEntry(CredentialUtil.this.alias);
            if (credEntry != null && (password = credEntry.getCredential()) != null) {
                credential = String.valueOf(password);
            }
            return credential;
        }

        @Override
        public String getUsage() {
            return "get <alias> [-provider provider-path]:\n\nThe get subcommand gets the credential for the specified alias\nfrom the provider specified through the -provider argument.\n";
        }
    }

    private abstract class Command {
        private Command() {
        }

        public boolean validate() {
            boolean rc = true;
            if (CredentialUtil.this.alias == null || CredentialUtil.this.alias.isEmpty()) {
                System.out.println("There is no alias specified. Please provide themandatory <alias>. See the usage description with -help.");
                rc = false;
            }
            if (CredentialUtil.this.provider == null) {
                System.out.println("There are no valid CredentialProviders configured.\nCredential will not be created.\nConsider using the -provider option to indicate the provider to use.");
                rc = false;
            }
            return rc;
        }

        public abstract String getUsage();

        public abstract int execute() throws Exception;
    }
}

