/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.utilities.state;

import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.ObjectNotFoundException;
import id.onyx.obdp.server.StaticallyInject;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.ServiceComponentHostRequest;
import id.onyx.obdp.server.controller.ServiceComponentHostResponse;
import id.onyx.obdp.server.controller.utilities.state.DefaultServiceCalculatedState;
import id.onyx.obdp.server.controller.utilities.state.ServiceCalculatedState;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.ComponentInfo;
import id.onyx.obdp.server.state.Service;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.server.state.State;
import java.util.Collections;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StaticallyInject
public final class HiveServiceCalculatedState
extends DefaultServiceCalculatedState
implements ServiceCalculatedState {
    private static final Logger LOG = LoggerFactory.getLogger(HiveServiceCalculatedState.class);

    @Override
    public State getState(String clusterName, String serviceName) {
        try {
            Cluster cluster = this.getCluster(clusterName);
            if (cluster != null && managementControllerProvider != null) {
                OBDPMetaInfo obdpMetaInfo = ((OBDPManagementController)managementControllerProvider.get()).getAmbariMetaInfo();
                Service service = cluster.getService(serviceName);
                StackId stackId = service.getDesiredStackId();
                ServiceComponentHostRequest request = new ServiceComponentHostRequest(clusterName, serviceName, null, null, null);
                Set<ServiceComponentHostResponse> hostComponentResponses = ((OBDPManagementController)managementControllerProvider.get()).getHostComponents(Collections.singleton(request), true);
                int activeHiveMetastoreComponentCount = 0;
                State nonStartedState = null;
                boolean embeddedMysqlComponentExists = false;
                boolean hiveServerComponentStarted = false;
                boolean webHcatComponentStarted = false;
                boolean mysqlComponentStarted = false;
                block7: for (ServiceComponentHostResponse hostComponentResponse : hostComponentResponses) {
                    try {
                        ComponentInfo componentInfo = obdpMetaInfo.getComponent(stackId.getStackName(), stackId.getStackVersion(), hostComponentResponse.getServiceName(), hostComponentResponse.getComponentName());
                        if (!componentInfo.isMaster()) continue;
                        State state = this.getHostComponentState(hostComponentResponse);
                        String componentName = hostComponentResponse.getComponentName();
                        if (componentName.equals("MYSQL_SERVER")) {
                            embeddedMysqlComponentExists = true;
                        }
                        switch (state) {
                            case STARTED: 
                            case DISABLED: {
                                if (componentName.equals("HIVE_METASTORE")) {
                                    ++activeHiveMetastoreComponentCount;
                                    break;
                                }
                                if (componentName.equals("HIVE_SERVER")) {
                                    hiveServerComponentStarted = true;
                                    break;
                                }
                                if (componentName.equals("MYSQL_SERVER")) {
                                    mysqlComponentStarted = true;
                                    break;
                                }
                                if (!componentName.equals("WEBHCAT_SERVER")) continue block7;
                                webHcatComponentStarted = true;
                                break;
                            }
                            default: {
                                nonStartedState = state;
                            }
                        }
                    }
                    catch (ObjectNotFoundException objectNotFoundException) {}
                }
                if (nonStartedState == null || hiveServerComponentStarted && webHcatComponentStarted && activeHiveMetastoreComponentCount > 0 && (!embeddedMysqlComponentExists || mysqlComponentStarted)) {
                    return State.STARTED;
                }
                return nonStartedState;
            }
        }
        catch (OBDPException e) {
            LOG.error("Can't determine service state.", (Throwable)e);
        }
        return State.UNKNOWN;
    }
}

