/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.utilities.state;

import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.ObjectNotFoundException;
import id.onyx.obdp.server.StaticallyInject;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.ServiceComponentHostRequest;
import id.onyx.obdp.server.controller.ServiceComponentHostResponse;
import id.onyx.obdp.server.controller.utilities.state.DefaultServiceCalculatedState;
import id.onyx.obdp.server.controller.utilities.state.ServiceCalculatedState;
import id.onyx.obdp.server.stack.NameService;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.ComponentInfo;
import id.onyx.obdp.server.state.ConfigHelper;
import id.onyx.obdp.server.state.Service;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.server.state.State;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StaticallyInject
public final class HDFSServiceCalculatedState
extends DefaultServiceCalculatedState
implements ServiceCalculatedState {
    private static final Logger LOG = LoggerFactory.getLogger(HDFSServiceCalculatedState.class);

    @Override
    public State getState(String clusterName, String serviceName) {
        try {
            Cluster cluster = this.getCluster(clusterName);
            if (cluster != null && managementControllerProvider != null) {
                OBDPMetaInfo obdpMetaInfo = ((OBDPManagementController)managementControllerProvider.get()).getAmbariMetaInfo();
                Service service = cluster.getService(serviceName);
                StackId stackId = service.getDesiredStackId();
                ServiceComponentHostRequest request = new ServiceComponentHostRequest(clusterName, serviceName, null, null, null);
                Set<ServiceComponentHostResponse> hostComponentResponses = ((OBDPManagementController)managementControllerProvider.get()).getHostComponents(Collections.singleton(request), true);
                HashSet<String> startedOrDisabledNNHosts = new HashSet<String>();
                int nameNodeCount = 0;
                int nameNodeStartedOrDisabledCount = 0;
                boolean hasSecondary = false;
                boolean hasJournal = false;
                State nonStartedState = null;
                block17: for (ServiceComponentHostResponse hostComponentResponse : hostComponentResponses) {
                    try {
                        ComponentInfo componentInfo = obdpMetaInfo.getComponent(stackId.getStackName(), stackId.getStackVersion(), hostComponentResponse.getServiceName(), hostComponentResponse.getComponentName());
                        if (!componentInfo.isMaster()) continue;
                        String componentName = hostComponentResponse.getComponentName();
                        boolean isNameNode = false;
                        switch (componentName) {
                            case "NAMENODE": {
                                ++nameNodeCount;
                                isNameNode = true;
                                break;
                            }
                            case "SECONDARY_NAMENODE": {
                                hasSecondary = true;
                                break;
                            }
                            case "JOURNALNODE": {
                                hasJournal = true;
                            }
                        }
                        State state = this.getHostComponentState(hostComponentResponse);
                        switch (state) {
                            case STARTED: 
                            case DISABLED: {
                                if (!isNameNode) continue block17;
                                ++nameNodeStartedOrDisabledCount;
                                startedOrDisabledNNHosts.add(hostComponentResponse.getHostname());
                                break;
                            }
                            default: {
                                nonStartedState = state;
                            }
                        }
                    }
                    catch (ObjectNotFoundException componentInfo) {}
                }
                boolean multipleNameServices = nameNodeCount > 2;
                int nameServiceWithStartedOrDisabledNNCount = 0;
                List<Object> nameServices = new ArrayList();
                if (multipleNameServices) {
                    ConfigHelper configHelper = ((OBDPManagementController)managementControllerProvider.get()).getConfigHelper();
                    nameServices = NameService.fromConfig(configHelper, cluster);
                    for (NameService nameService : nameServices) {
                        boolean hasStartedOrDisabledNN = false;
                        for (NameService.NameNode nameNode : nameService.getNameNodes()) {
                            if (!startedOrDisabledNNHosts.contains(nameNode.getHost())) continue;
                            hasStartedOrDisabledNN = true;
                            break;
                        }
                        if (!hasStartedOrDisabledNN) continue;
                        ++nameServiceWithStartedOrDisabledNNCount;
                    }
                }
                if (nonStartedState == null || (nameNodeCount > 0 && !hasSecondary || hasJournal) && nameNodeStartedOrDisabledCount > 0 && (!multipleNameServices || nameServiceWithStartedOrDisabledNNCount == nameServices.size())) {
                    return State.STARTED;
                }
                return nonStartedState;
            }
        }
        catch (OBDPException e) {
            LOG.error("Can't determine service state.", (Throwable)e);
        }
        return State.UNKNOWN;
    }
}

