/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.utilities.state;

import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.StaticallyInject;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.ServiceComponentHostRequest;
import id.onyx.obdp.server.controller.ServiceComponentHostResponse;
import id.onyx.obdp.server.controller.utilities.state.DefaultServiceCalculatedState;
import id.onyx.obdp.server.controller.utilities.state.ServiceCalculatedState;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.State;
import java.util.Collections;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StaticallyInject
public final class FlumeServiceCalculatedState
extends DefaultServiceCalculatedState
implements ServiceCalculatedState {
    private static final Logger LOG = LoggerFactory.getLogger(FlumeServiceCalculatedState.class);

    @Override
    public State getState(String clusterName, String serviceName) {
        try {
            Cluster cluster = this.getCluster(clusterName);
            if (cluster != null && managementControllerProvider != null) {
                ServiceComponentHostRequest request = new ServiceComponentHostRequest(clusterName, serviceName, null, null, null);
                Set<ServiceComponentHostResponse> hostComponentResponses = ((OBDPManagementController)managementControllerProvider.get()).getHostComponents(Collections.singleton(request), true);
                State state = State.UNKNOWN;
                for (ServiceComponentHostResponse schr : hostComponentResponses) {
                    State schState = this.getHostComponentState(schr);
                    if (schState.ordinal() >= state.ordinal()) continue;
                    state = schState;
                }
                return state;
            }
        }
        catch (OBDPException e) {
            LOG.error("Can't determine service state.", (Throwable)e);
        }
        return State.UNKNOWN;
    }
}

